/*
 * Decompiled with CFR 0.152.
 */
package csv.impl.csv.type;

import csv.mapper.TypeConverter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;

public class ZonedDateTimeConversionHandler
implements TypeConverter {
    public static final ZonedDateTimeConversionHandler INSTANCE = new ZonedDateTimeConversionHandler();
    private static final String DEFAULT_PRINT_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String[] DEFAULT_DATE_FORMATS = new String[]{"dd/MM/yyyy", "dd.MM.yyyy", "dd/MM/yy", "dd.MM.yy", "yyyy/MM/dd", "yyyy.MM.dd", "yyyy-MM-dd"};
    private static final String[] DEFAULT_TIME_FORMATS = new String[]{"HH:mm", "HH:mm:ss", "HH:mm:ss.S", "HH:mm Z", "HH:mm:ss Z", "HH:mm:ss.S Z"};
    private static DateTimeFormatter[] STANDARD_FORMATTERS = new DateTimeFormatter[]{DateTimeFormatter.BASIC_ISO_DATE, DateTimeFormatter.ISO_DATE, DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.ISO_INSTANT, DateTimeFormatter.ISO_LOCAL_TIME, DateTimeFormatter.ISO_LOCAL_DATE_TIME, DateTimeFormatter.ISO_OFFSET_DATE, DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ISO_OFFSET_TIME, DateTimeFormatter.ISO_ORDINAL_DATE, DateTimeFormatter.ISO_TIME, DateTimeFormatter.ISO_WEEK_DATE, DateTimeFormatter.ISO_ZONED_DATE_TIME, DateTimeFormatter.RFC_1123_DATE_TIME};
    private static String[] DEFAULT_FORMATS;
    private String[] parsingFormats = null;
    private DateTimeFormatter[] parsingFormatters = null;
    private String printFormat = null;
    private DateTimeFormatter printFormatter = null;
    private ZoneId zoneId = null;

    @Override
    public Class<?>[] getTypes() {
        return new Class[]{ZonedDateTime.class};
    }

    @Override
    public Object fromStream(Object o) {
        DateTimeFormatter[] formats;
        if (o == null) {
            return null;
        }
        String s = o.toString().trim();
        for (DateTimeFormatter parser : formats = this.getParsingFormatters()) {
            try {
                TemporalAccessor rc = parser.parse(s);
                return ZonedDateTime.from(rc);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return s;
    }

    @Override
    public Object toStream(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof TemporalAccessor) {
            return this.getPrintFormatter().format((TemporalAccessor)o);
        }
        return o.toString();
    }

    public DateTimeFormatter[] getParsingFormatters() {
        if (this.parsingFormatters == null) {
            int i;
            String[] formats = this.getParsingFormats();
            this.parsingFormatters = new DateTimeFormatter[formats.length + STANDARD_FORMATTERS.length];
            for (i = 0; i < formats.length; ++i) {
                this.parsingFormatters[i] = DateTimeFormatter.ofPattern(formats[i]).withZone(this.getZoneId());
            }
            for (i = 0; i < STANDARD_FORMATTERS.length; ++i) {
                this.parsingFormatters[i + formats.length] = STANDARD_FORMATTERS[i];
            }
        }
        return this.parsingFormatters;
    }

    public String[] getParsingFormats() {
        if (this.parsingFormats == null) {
            this.parsingFormats = DEFAULT_FORMATS;
        }
        return this.parsingFormats;
    }

    public void setParsingFormats(String[] parsingFormats) {
        this.parsingFormats = parsingFormats;
        this.parsingFormatters = null;
        this.printFormatter = null;
    }

    public String getPrintFormat() {
        if (this.printFormat == null) {
            this.printFormat = DEFAULT_PRINT_FORMAT;
        }
        return this.printFormat;
    }

    public void setPrintFormat(String printFormat) {
        this.printFormat = printFormat;
        this.printFormatter = null;
    }

    public DateTimeFormatter getPrintFormatter() {
        if (this.printFormatter == null) {
            this.printFormatter = DateTimeFormatter.ofPattern(this.getPrintFormat()).withZone(this.getZoneId());
        }
        return this.printFormatter;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
        if (this.printFormatter != null) {
            this.printFormatter = this.printFormatter.withZone(zoneId);
        }
        if (this.parsingFormatters != null) {
            for (int i = 0; i < this.parsingFormatters.length; ++i) {
                this.parsingFormatters[i] = this.parsingFormatters[i].withZone(zoneId);
            }
        }
    }

    public ZoneId getZoneId() {
        if (this.zoneId == null) {
            if (this.printFormatter != null) {
                return this.printFormatter.getZone();
            }
            return ZoneId.systemDefault();
        }
        return this.zoneId;
    }

    static {
        ArrayList<Object> l = new ArrayList<Object>();
        for (String d : DEFAULT_DATE_FORMATS) {
            l.add(d);
            for (String t : DEFAULT_TIME_FORMATS) {
                l.add(t);
                l.add(d + " " + t);
            }
        }
        DEFAULT_FORMATS = l.toArray(new String[l.size()]);
    }
}

