/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.CsvException;
import csv.impl.AbstractTableReader;
import csv.util.CSVUtils;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class JdbcReader
extends AbstractTableReader {
    private ResultSet resultSet;
    private Object[] nextRow = null;
    private int columnCount = 0;
    private boolean closeResultSet = false;

    public JdbcReader(ResultSet resultSet) {
        this.setResultSet(resultSet);
        this.setHasHeaderRow(true);
    }

    public JdbcReader(Statement statement) throws SQLException {
        this(statement.getResultSet());
    }

    protected void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public void close() {
        try {
            if (!this.resultSet.isClosed() && this.isCloseResultSet()) {
                this.resultSet.close();
            }
        }
        catch (SQLException e) {
            throw new CsvException("Error while closing result set", e);
        }
        super.close();
    }

    @Override
    public void open() {
        super.open();
        this.nextRow = null;
        this.columnCount = 0;
    }

    @Override
    public void reset() {
        try {
            this.resultSet.beforeFirst();
        }
        catch (SQLException e) {
            throw new CsvException("Cannot relocate cursor", e);
        }
        this.nextRow = null;
        this.columnCount = 0;
        super.reset();
    }

    @Override
    protected void readHeaderRow() {
        try {
            ResultSetMetaData meta = this.resultSet.getMetaData();
            int colcount = meta.getColumnCount();
            String[] l = new String[colcount];
            for (int i = 0; i < colcount; ++i) {
                l[i] = meta.getColumnName(i + 1);
            }
            this.setHeaderRow(CSVUtils.extendArray(l, this.getMinimumColumnCount()));
        }
        catch (SQLException e) {
            throw new CsvException("Cannot read column names", e);
        }
    }

    public int getColumnCount() {
        if (this.columnCount <= 0) {
            try {
                ResultSetMetaData meta = this.resultSet.getMetaData();
                this.columnCount = meta.getColumnCount();
            }
            catch (SQLException e) {
                throw new CsvException("Cannot read column names", e);
            }
        }
        return this.columnCount;
    }

    @Override
    public boolean hasNext() {
        if (this.nextRow == null) {
            this.readNextRow();
        }
        return this.nextRow != null;
    }

    @Override
    public Object[] next() {
        if (this.nextRow == null) {
            this.readNextRow();
        }
        Object[] rc = this.nextRow;
        this.nextRow = null;
        this.incrementRowCount();
        return rc;
    }

    protected void readNextRow() {
        if (this.nextRow != null) {
            return;
        }
        try {
            this.readHeaderRow();
            if (this.resultSet.next()) {
                this.nextRow = new Object[this.getColumnCount()];
                for (int i = 0; i < this.nextRow.length; ++i) {
                    this.nextRow[i] = this.resultSet.getObject(i + 1);
                }
            }
        }
        catch (SQLException e) {
            throw new CsvException("Cannot read next row", e);
        }
    }

    @Override
    public void remove() {
        try {
            this.resultSet.deleteRow();
        }
        catch (SQLException e) {
            throw new CsvException("Cannot delete row", e);
        }
    }

    public boolean isCloseResultSet() {
        return this.closeResultSet;
    }

    public void setCloseResultSet(boolean closeResultSet) {
        this.closeResultSet = closeResultSet;
    }
}

