/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.impl.ExcelFormatter;
import csv.impl.ExcelWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class DefaultExcelFormatter
implements ExcelFormatter {
    public static final String DEFAULT_FONT_NAME = "Arial";
    public static final short DEFAULT_FONT_COLOR = IndexedColors.BLACK.getIndex();
    public static final short HYPERLINK_FONT_COLOR = IndexedColors.BLUE.getIndex();
    public static final short DEFAULT_FONT_SIZE = 10;
    public static final String DEFAULT_DATE_FORMAT = "dd.mm.yyyy hh:mm";
    public static final String DEFAULT_INTEGER_FORMAT = "0";
    public static final String DEFAULT_REAL_FORMAT = "0.00";
    private boolean emphasizeFirstRow;
    private Font defaultBoldFont;
    private Font defaultPlainFont;
    private Font defaultHyperlinkFont;
    private String defaultFontName;
    private short defaultFontSize;
    private short defaultFontColor;
    private short defaultHyperlinkColor;
    private Map<String, Short> dateFormat;
    private Map<String, Short> intFormat;
    private Map<String, Short> realFormat;
    private Map<StyleDescription, CellStyle> styles;
    private Short borderColor;
    private BorderStyle borderThickness;

    public DefaultExcelFormatter() {
        this(false);
    }

    public DefaultExcelFormatter(boolean emphasizeFirstRow) {
        this(emphasizeFirstRow, null, null, null, null);
    }

    public DefaultExcelFormatter(boolean emphasizeFirstRow, String defaultFontName, Short defaultFontSize, Short defaultFontColor, Short defaultHyperlinkColor) {
        this.emphasizeFirstRow = emphasizeFirstRow;
        this.defaultFontName = defaultFontName != null ? defaultFontName : DEFAULT_FONT_NAME;
        this.defaultFontSize = (short)(defaultFontSize != null ? (int)defaultFontSize.shortValue() : 10);
        this.defaultFontColor = defaultFontColor != null ? defaultFontColor : DEFAULT_FONT_COLOR;
        this.defaultHyperlinkColor = defaultHyperlinkColor != null ? defaultHyperlinkColor : HYPERLINK_FONT_COLOR;
        this.init();
    }

    public void init() {
        this.defaultBoldFont = null;
        this.defaultPlainFont = null;
        this.defaultHyperlinkFont = null;
        this.dateFormat = new HashMap<String, Short>();
        this.intFormat = new HashMap<String, Short>();
        this.realFormat = new HashMap<String, Short>();
        this.styles = new HashMap<StyleDescription, CellStyle>();
    }

    @Override
    public void setStyle(ExcelWriter writer, Cell cell, Object value) {
        Hyperlink link;
        int row = cell.getRowIndex();
        int column = cell.getColumnIndex();
        StyleDescription desc = new StyleDescription();
        desc.setFormat(this.getFormat(writer, row, column, value));
        desc.setFgColor(this.getForegroundColor(writer, row, column, value));
        desc.setFillPattern(this.getFillPattern(writer, row, column, value));
        desc.setBgColor(this.getBackgroundColor(writer, row, column, value));
        desc.setFont(this.getFont(writer, row, column, value));
        desc.setTopBorderColor(this.getTopBorderColor(writer, row, column, value));
        desc.setLeftBorderColor(this.getLeftBorderColor(writer, row, column, value));
        desc.setRightBorderColor(this.getRightBorderColor(writer, row, column, value));
        desc.setBottomBorderColor(this.getBottomBorderColor(writer, row, column, value));
        desc.setTopBorderThickness(this.getTopBorderThickness(writer, row, column, value));
        desc.setLeftBorderThickness(this.getLeftBorderThickness(writer, row, column, value));
        desc.setRightBorderThickness(this.getRightBorderThickness(writer, row, column, value));
        desc.setBottomBorderThickness(this.getBottomBorderThickness(writer, row, column, value));
        desc.setTextWrap(this.isTextWrap(writer, row, column, value));
        desc.setAlignment(this.getAlign(writer, row, column, value));
        if (!desc.isDefault()) {
            CellStyle style = this.styles.get(desc);
            if (style == null) {
                style = writer.getWorkbook().createCellStyle();
                this.styles.put(desc, style);
                desc.applyStyle(style);
            }
            desc.applyStyle(style);
            cell.setCellStyle(style);
        }
        if ((link = this.getHyperlink(writer, row, column, value)) != null) {
            cell.setHyperlink(link);
        }
    }

    public Hyperlink getHyperlink(ExcelWriter writer, int row, int column, Object value) {
        return null;
    }

    @Override
    public void finalize(ExcelWriter writer, int rowCount, int columnCount) {
        Sheet sheet = writer.getSheet();
        for (int i = 0; i <= columnCount; ++i) {
            sheet.autoSizeColumn(i);
        }
    }

    public HorizontalAlignment getAlign(ExcelWriter writer, int row, int column, Object value) {
        if (value instanceof Number) {
            return HorizontalAlignment.RIGHT;
        }
        return null;
    }

    public Short getFormat(ExcelWriter writer, int row, int column, Object value) {
        if (value instanceof Date) {
            return this.getDateFormat(writer, this.getDateFormat(row, column, value));
        }
        if (value instanceof Integer || value instanceof Long || value instanceof Short) {
            return this.getIntegerFormat(writer, this.getIntegerFormat(row, column, value));
        }
        if (value instanceof Double || value instanceof Float) {
            return this.getRealFormat(writer, this.getRealFormat(row, column, value));
        }
        return null;
    }

    protected Short getDateFormat(ExcelWriter writer, String format) {
        Short rc = this.dateFormat.get(format);
        if (rc == null) {
            CreationHelper createHelper = writer.getWorkbook().getCreationHelper();
            rc = createHelper.createDataFormat().getFormat(format);
            this.dateFormat.put(format, rc);
        }
        return rc;
    }

    protected Short getIntegerFormat(ExcelWriter writer, String format) {
        Short rc = this.intFormat.get(format);
        if (rc == null) {
            DataFormat formatHelper = writer.getWorkbook().createDataFormat();
            rc = formatHelper.getFormat(format);
            this.intFormat.put(format, rc);
        }
        return rc;
    }

    protected Short getRealFormat(ExcelWriter writer, String format) {
        Short rc = this.intFormat.get(format);
        if (rc == null) {
            DataFormat formatHelper = writer.getWorkbook().createDataFormat();
            rc = formatHelper.getFormat(format);
            this.realFormat.put(format, rc);
        }
        return rc;
    }

    public String getDateFormat(int row, int column, Object value) {
        return DEFAULT_DATE_FORMAT;
    }

    public String getIntegerFormat(int row, int column, Object value) {
        return DEFAULT_INTEGER_FORMAT;
    }

    public String getRealFormat(int row, int column, Object value) {
        return DEFAULT_REAL_FORMAT;
    }

    public Short getBackgroundColor(ExcelWriter writer, int row, int column, Object value) {
        return null;
    }

    public FillPatternType getFillPattern(ExcelWriter writer, int row, int column, Object value) {
        if (this.getForegroundColor(writer, row, column, value) != null) {
            return FillPatternType.SOLID_FOREGROUND;
        }
        return null;
    }

    public Short getForegroundColor(ExcelWriter writer, int row, int column, Object value) {
        return null;
    }

    public Font getFont(ExcelWriter writer, int row, int column, Object value) {
        if (this.emphasizeFirstRow && row == 0) {
            return this.getBoldFont(writer.getWorkbook(), row, column, value);
        }
        if (this.getHyperlink(writer, row, column, value) != null) {
            return this.getHyperlinkFont(writer.getWorkbook(), row, column, value);
        }
        return this.getPlainFont(writer.getWorkbook(), row, column, value);
    }

    public short getDefaultFontSize() {
        return this.defaultFontSize;
    }

    public short getDefaultFontColor() {
        return this.defaultFontColor;
    }

    public short getDefaultHyperlinkColor() {
        return this.defaultHyperlinkColor;
    }

    public String getDefaultFontName() {
        return this.defaultFontName;
    }

    public boolean isEmphasizeFirstRow() {
        return this.emphasizeFirstRow;
    }

    public void setEmphasizeFirstRow(boolean emphasizeFirstRow) {
        this.emphasizeFirstRow = emphasizeFirstRow;
    }

    public Font getBoldFont(Workbook workbook, int row, int column, Object value) {
        return this.getDefaultBoldFont(workbook);
    }

    public Font getDefaultBoldFont(Workbook workbook) {
        if (this.defaultBoldFont == null) {
            this.defaultBoldFont = workbook.createFont();
            this.defaultBoldFont.setBold(true);
            this.defaultBoldFont.setColor(this.getDefaultFontColor());
            this.defaultBoldFont.setFontHeightInPoints(this.getDefaultFontSize());
            this.defaultBoldFont.setFontName(this.getDefaultFontName());
        }
        return this.defaultBoldFont;
    }

    public Font getPlainFont(Workbook workbook, int row, int column, Object value) {
        return this.getDefaultPlainFont(workbook);
    }

    public Font getDefaultPlainFont(Workbook workbook) {
        if (this.defaultPlainFont == null) {
            this.defaultPlainFont = workbook.createFont();
            this.defaultPlainFont.setBold(false);
            this.defaultPlainFont.setColor(this.getDefaultFontColor());
            this.defaultPlainFont.setFontHeightInPoints(this.getDefaultFontSize());
            this.defaultPlainFont.setFontName(this.getDefaultFontName());
        }
        return this.defaultPlainFont;
    }

    public Font getHyperlinkFont(Workbook workbook, int row, int column, Object value) {
        return this.getDefaultHyperlinkFont(workbook);
    }

    public Font getDefaultHyperlinkFont(Workbook workbook) {
        if (this.defaultHyperlinkFont == null) {
            this.defaultHyperlinkFont = workbook.createFont();
            this.defaultHyperlinkFont.setBold(false);
            this.defaultHyperlinkFont.setColor(this.getDefaultHyperlinkColor());
            this.defaultHyperlinkFont.setFontHeightInPoints(this.getDefaultFontSize());
            this.defaultHyperlinkFont.setFontName(this.getDefaultFontName());
            this.defaultHyperlinkFont.setUnderline((byte)1);
        }
        return this.defaultHyperlinkFont;
    }

    public Short getTopBorderColor(ExcelWriter writer, int row, int column, Object value) {
        return this.borderColor;
    }

    public Short getLeftBorderColor(ExcelWriter writer, int row, int column, Object value) {
        return this.borderColor;
    }

    public Short getRightBorderColor(ExcelWriter writer, int row, int column, Object value) {
        return this.borderColor;
    }

    public Short getBottomBorderColor(ExcelWriter writer, int row, int column, Object value) {
        return this.borderColor;
    }

    public BorderStyle getTopBorderThickness(ExcelWriter writer, int row, int column, Object value) {
        return this.borderThickness;
    }

    public BorderStyle getLeftBorderThickness(ExcelWriter writer, int row, int column, Object value) {
        return this.borderThickness;
    }

    public BorderStyle getRightBorderThickness(ExcelWriter writer, int row, int column, Object value) {
        return this.borderThickness;
    }

    public BorderStyle getBottomBorderThickness(ExcelWriter writer, int row, int column, Object value) {
        return this.borderThickness;
    }

    public void setDefaultBorderColor(Short borderColor) {
        this.borderColor = borderColor;
    }

    public void setDefaultBorderThickness(BorderStyle borderThickness) {
        this.borderThickness = borderThickness;
    }

    public boolean isTextWrap(ExcelWriter writer, int row, int column, Object value) {
        return value instanceof String;
    }

    protected static class StyleDescription {
        private Short format;
        private Short fgColor;
        private FillPatternType fillPattern;
        private Short bgColor;
        private Font font;
        private HorizontalAlignment alignment;
        private Short topBorderColor;
        private BorderStyle topBorderThickness;
        private Short leftBorderColor;
        private BorderStyle leftBorderThickness;
        private Short rightBorderColor;
        private BorderStyle rightBorderThickness;
        private Short bottomBorderColor;
        private BorderStyle bottomBorderThickness;
        private boolean textWrap;
        protected static final String DEFAULT_DESC = "null:null:null:null:null:null:null:null:null:null:null:null:null:false";

        public StyleDescription() {
            this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, false);
        }

        public StyleDescription(Short format, Short fgColor, FillPatternType fillPattern, Short bgColor, Font font, HorizontalAlignment alignment, Short topBorderColor, BorderStyle topBorderThickness, Short leftBorderColor, BorderStyle leftBorderThickness, Short rightBorderColor, BorderStyle rightBorderThickness, Short bottomBorderColor, BorderStyle bottomBorderThickness, boolean textWrap) {
            this.format = format;
            this.fgColor = fgColor;
            this.fillPattern = fillPattern;
            this.bgColor = bgColor;
            this.font = font;
            this.alignment = alignment;
            this.topBorderColor = topBorderColor;
            this.topBorderThickness = topBorderThickness;
            this.leftBorderColor = leftBorderColor;
            this.leftBorderThickness = leftBorderThickness;
            this.rightBorderColor = rightBorderColor;
            this.rightBorderThickness = rightBorderThickness;
            this.bottomBorderColor = bottomBorderColor;
            this.bottomBorderThickness = bottomBorderThickness;
            this.textWrap = textWrap;
        }

        public Short getFormat() {
            return this.format;
        }

        public void setFormat(Short format) {
            this.format = format;
        }

        public Short getFgColor() {
            return this.fgColor;
        }

        public void setFgColor(Short fgColor) {
            this.fgColor = fgColor;
        }

        public FillPatternType getFillPattern() {
            return this.fillPattern;
        }

        public void setFillPattern(FillPatternType fillPattern) {
            this.fillPattern = fillPattern;
        }

        public Short getBgColor() {
            return this.bgColor;
        }

        public void setBgColor(Short bgColor) {
            this.bgColor = bgColor;
        }

        public Font getFont() {
            return this.font;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public HorizontalAlignment getAlignment() {
            return this.alignment;
        }

        public void setAlignment(HorizontalAlignment alignment) {
            this.alignment = alignment;
        }

        public Short getTopBorderColor() {
            return this.topBorderColor;
        }

        public void setTopBorderColor(Short topBorderColor) {
            this.topBorderColor = topBorderColor;
        }

        public BorderStyle getTopBorderThickness() {
            return this.topBorderThickness;
        }

        public void setTopBorderThickness(BorderStyle topBorderThickness) {
            this.topBorderThickness = topBorderThickness;
        }

        public Short getLeftBorderColor() {
            return this.leftBorderColor;
        }

        public void setLeftBorderColor(Short leftBorderColor) {
            this.leftBorderColor = leftBorderColor;
        }

        public BorderStyle getLeftBorderThickness() {
            return this.leftBorderThickness;
        }

        public void setLeftBorderThickness(BorderStyle leftBorderThickness) {
            this.leftBorderThickness = leftBorderThickness;
        }

        public Short getRightBorderColor() {
            return this.rightBorderColor;
        }

        public void setRightBorderColor(Short rightBorderColor) {
            this.rightBorderColor = rightBorderColor;
        }

        public BorderStyle getRightBorderThickness() {
            return this.rightBorderThickness;
        }

        public void setRightBorderThickness(BorderStyle rightBorderThickness) {
            this.rightBorderThickness = rightBorderThickness;
        }

        public Short getBottomBorderColor() {
            return this.bottomBorderColor;
        }

        public void setBottomBorderColor(Short bottomBorderColor) {
            this.bottomBorderColor = bottomBorderColor;
        }

        public BorderStyle getBottomBorderThickness() {
            return this.bottomBorderThickness;
        }

        public void setBottomBorderThickness(BorderStyle bottomBorderThickness) {
            this.bottomBorderThickness = bottomBorderThickness;
        }

        public boolean isTextWrap() {
            return this.textWrap;
        }

        public void setTextWrap(boolean textWrap) {
            this.textWrap = textWrap;
        }

        public void applyStyle(CellStyle style) {
            if (this.format != null) {
                style.setDataFormat(this.format.shortValue());
            }
            if (this.fgColor != null) {
                style.setFillForegroundColor(this.fgColor.shortValue());
                if (this.fillPattern != null) {
                    style.setFillPattern(this.fillPattern);
                }
            }
            if (this.bgColor != null) {
                style.setFillBackgroundColor(this.bgColor.shortValue());
            }
            if (this.font != null) {
                style.setFont(this.font);
            }
            if (this.alignment != null) {
                style.setAlignment(this.alignment);
            }
            if (this.topBorderColor != null) {
                style.setTopBorderColor(this.topBorderColor.shortValue());
            }
            if (this.leftBorderColor != null) {
                style.setLeftBorderColor(this.leftBorderColor.shortValue());
            }
            if (this.rightBorderColor != null) {
                style.setRightBorderColor(this.rightBorderColor.shortValue());
            }
            if (this.bottomBorderColor != null) {
                style.setBottomBorderColor(this.bottomBorderColor.shortValue());
            }
            if (this.topBorderThickness != null) {
                style.setBorderTop(this.topBorderThickness);
            }
            if (this.leftBorderThickness != null) {
                style.setBorderLeft(this.leftBorderThickness);
            }
            if (this.rightBorderThickness != null) {
                style.setBorderRight(this.rightBorderThickness);
            }
            if (this.bottomBorderThickness != null) {
                style.setBorderBottom(this.bottomBorderThickness);
            }
            style.setWrapText(this.isTextWrap());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return obj.toString().equals(this.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            StringBuilder rc = new StringBuilder();
            rc.append(this.getFgColor());
            rc.append(':');
            rc.append(this.getFillPattern());
            rc.append(':');
            rc.append(this.getBgColor());
            rc.append(':');
            Font font = this.getFont();
            if (font != null) {
                rc.append(font.getIndex());
            } else {
                rc.append("null");
            }
            rc.append(':');
            rc.append(this.getAlignment());
            rc.append(':');
            rc.append(this.getTopBorderColor());
            rc.append(':');
            rc.append(this.getTopBorderThickness());
            rc.append(':');
            rc.append(this.getLeftBorderColor());
            rc.append(':');
            rc.append(this.getLeftBorderThickness());
            rc.append(':');
            rc.append(this.getRightBorderColor());
            rc.append(':');
            rc.append(this.getRightBorderThickness());
            rc.append(':');
            rc.append(this.getBottomBorderColor());
            rc.append(':');
            rc.append(this.getBottomBorderThickness());
            rc.append(':');
            rc.append(this.isTextWrap());
            return rc.toString();
        }

        public boolean isDefault() {
            return this.toString().equalsIgnoreCase(DEFAULT_DESC);
        }
    }
}

