/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.TableWriter;
import csv.mapper.StreamMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractTableWriter
implements TableWriter {
    private int rowCount;
    private StreamMapper mapper = null;

    protected void init() {
        this.rowCount = 0;
    }

    public StreamMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(StreamMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void printComment(String comment) throws IOException {
    }

    @Override
    public void printComment(String comment, int row, int column) throws IOException {
    }

    @Override
    public void close() {
    }

    public int getRowCount() {
        return this.rowCount;
    }

    protected int incrementRowCount() {
        ++this.rowCount;
        return this.rowCount;
    }

    protected Object convert(Object value) {
        if (this.mapper == null) {
            return value;
        }
        return this.mapper.toStream(value);
    }

    @Override
    public void printRow(Collection<?> columns) throws IOException {
        this.printRow(columns.iterator(), columns.size());
    }

    @Override
    public void printRow(Iterator<?> columns, int size) throws IOException {
        Object[] o = new Object[size];
        for (int i = 0; columns.hasNext() && i < size; ++i) {
            o[i] = columns.next();
        }
        this.printRow(o);
    }

    @Override
    public void printRow(Iterator<?> columns) throws IOException {
        ArrayList o = new ArrayList();
        while (columns.hasNext()) {
            o.add(columns.next());
        }
        this.printRow(o.toArray());
    }
}

