/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.CommentCallback;
import csv.CsvException;
import csv.TableReader;
import csv.mapper.StreamMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractTableReader
implements TableReader {
    private List<CommentCallback> commentCallbacks = new ArrayList<CommentCallback>();
    private int rowCount = 0;
    private int lineCount = 0;
    private boolean hasHeaderRow = false;
    private Object[] headerRow = null;
    private boolean headerRowRead = false;
    private int minimumColumnCount = 0;
    private StreamMapper mapper = null;
    private Map<Integer, Class<?>> columnTypes = new HashMap();

    public StreamMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(StreamMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void open() {
        this.rowCount = 0;
        this.lineCount = 0;
        this.headerRow = null;
        this.setHeaderRowRead(false);
    }

    @Override
    public void reset() {
        this.rowCount = 0;
        this.lineCount = 0;
        this.headerRow = null;
        this.setHeaderRowRead(false);
    }

    @Override
    public Object[] getHeaderRow() {
        if (!this.hasHeaderRow()) {
            return null;
        }
        if (!this.isHeaderRowRead()) {
            this.readHeaderRow();
        }
        return this.headerRow;
    }

    protected void readHeaderRow() {
    }

    protected void setHeaderRow(String[] names) {
        this.setHeaderRowRead(true);
        this.headerRow = names;
    }

    protected void setHeaderRowRead(boolean headerRowRead) {
        this.headerRowRead = headerRowRead;
    }

    public Object get(String name, Object[] row) {
        if (row == null) {
            return null;
        }
        int column = this.getColumnIndex(name);
        if (column < 0 || column >= row.length) {
            return null;
        }
        return row[column];
    }

    @Override
    public int getColumnIndex(String name) {
        if (!this.hasHeaderRow()) {
            throw new CsvException("TableReader has no header row (property hasHeaderRow is false)");
        }
        this.readHeaderRow();
        if (this.getHeaderRow() == null) {
            throw new CsvException("Stream is empty");
        }
        for (int i = 0; i < this.headerRow.length; ++i) {
            if (this.headerRow[i] == null || !this.headerRow[i].toString().equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public void setColumnType(int columnIndex, Class<?> type) {
        this.columnTypes.put(columnIndex, type);
    }

    public Class<?> getColumnType(int columnIndex) {
        Class<Object> rc = this.columnTypes.get(columnIndex);
        if (rc == null) {
            rc = Object.class;
        }
        return rc;
    }

    @Override
    public boolean hasHeaderRow() {
        return this.hasHeaderRow;
    }

    @Override
    public void setHasHeaderRow(boolean hasHeaderRow) {
        this.hasHeaderRow = hasHeaderRow;
    }

    @Deprecated
    public void addCommentCallBack(CommentCallback callback) {
        this.commentCallbacks.add(callback);
    }

    @Override
    public void registerCommentCallBack(CommentCallback callback) {
        this.commentCallbacks.add(callback);
    }

    @Deprecated
    public void removeCommentCallBack(CommentCallback callback) {
        this.commentCallbacks.remove(callback);
    }

    @Override
    public void unregisterCommentCallBack(CommentCallback callback) {
        this.commentCallbacks.remove(callback);
    }

    @Override
    public Iterator<Object[]> iterator() {
        return this;
    }

    protected void notifyComment(String s, int row, int cell) {
        for (CommentCallback callback : this.commentCallbacks) {
            callback.comment(this, s, row, cell);
        }
    }

    protected Object convert(int columnIndex, Object value) {
        if (this.mapper == null) {
            return value;
        }
        return this.mapper.fromStream(this.getColumnType(columnIndex), value);
    }

    protected Object convert(Class<?> type, Object value) {
        if (this.mapper == null) {
            return value;
        }
        return this.mapper.fromStream(type, value);
    }

    protected int incrementLineCount() {
        ++this.lineCount;
        return this.getLineCount();
    }

    public int getLineCount() {
        return this.lineCount;
    }

    protected int incrementRowCount() {
        ++this.rowCount;
        return this.getRowCount();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public void close() {
    }

    @Override
    public void setMinimumColumnCount(int length) {
        this.minimumColumnCount = length;
    }

    @Override
    public int getMinimumColumnCount() {
        return this.minimumColumnCount;
    }

    protected Object[] convertArray(List<String> columns) {
        int colcount = columns != null ? columns.size() : 0;
        Object[] rc = new Object[Math.max(colcount, this.getMinimumColumnCount())];
        if (columns != null && colcount > 0) {
            for (int i = 0; i < colcount; ++i) {
                rc[i] = this.convert(i, (Object)columns.get(i));
            }
        }
        return rc;
    }

    protected Object[] convertArray(String[] columns) {
        int colcount = this.getMinimumColumnCount();
        if (columns != null) {
            colcount = columns.length;
        }
        Object[] rc = new Object[Math.max(colcount, this.getMinimumColumnCount())];
        if (columns != null && colcount > 0) {
            for (int i = 0; i < colcount; ++i) {
                rc[i] = this.convert(i, (Object)columns[i]);
            }
        }
        return rc;
    }

    public boolean isHeaderRowRead() {
        return this.headerRowRead;
    }
}

