/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.CommentCallback;
import csv.CsvException;
import csv.TableReader;
import csv.impl.AbstractTableReader;
import java.util.Iterator;

public abstract class AbstractRowFilter
implements TableReader {
    private TableReader reader;
    private Object[] nextRow = null;
    private int rawRowIndex = 0;
    private int rowIndex = 0;

    public AbstractRowFilter(TableReader reader) {
        this.reader = reader;
    }

    protected TableReader getReader() {
        return this.reader;
    }

    @Override
    public void close() {
        this.getReader().close();
    }

    public Object get(String name, Object[] row) {
        if (this.getReader() instanceof AbstractTableReader) {
            return ((AbstractTableReader)this.getReader()).get(name, row);
        }
        return null;
    }

    @Override
    public int getColumnIndex(String name) {
        return this.getReader().getColumnIndex(name);
    }

    @Override
    public Object[] getHeaderRow() {
        return this.getReader().getHeaderRow();
    }

    @Override
    public int getMinimumColumnCount() {
        return this.getReader().getMinimumColumnCount();
    }

    @Override
    public boolean hasHeaderRow() {
        return this.getReader().hasHeaderRow();
    }

    @Override
    public void open() {
        this.getReader().open();
        this.nextRow = null;
        this.rawRowIndex = 0;
        this.rowIndex = 0;
    }

    @Override
    public Iterator<Object[]> iterator() {
        return this;
    }

    @Override
    public void registerCommentCallBack(CommentCallback callback) {
        this.getReader().registerCommentCallBack(callback);
    }

    @Override
    public void reset() {
        this.getReader().reset();
        this.nextRow = null;
        this.rawRowIndex = 0;
        this.rowIndex = 0;
    }

    @Override
    public void setHasHeaderRow(boolean hasHeaderRow) {
        this.getReader().setHasHeaderRow(hasHeaderRow);
    }

    @Override
    public void setMinimumColumnCount(int length) {
        this.getReader().setMinimumColumnCount(length);
    }

    @Override
    public void unregisterCommentCallBack(CommentCallback callback) {
        this.getReader().unregisterCommentCallBack(callback);
    }

    @Override
    public boolean hasNext() {
        if (this.nextRow == null) {
            this.findNextRow();
        }
        return this.nextRow != null;
    }

    protected void findNextRow() {
        while (this.nextRow == null && this.isMoreRowsExpected() && this.getReader().hasNext()) {
            Object[] row = (Object[])this.getReader().next();
            if (this.isValidRow(row)) {
                this.nextRow = row;
            }
            ++this.rawRowIndex;
        }
    }

    protected abstract boolean isValidRow(Object[] var1);

    protected boolean isMoreRowsExpected() {
        return true;
    }

    protected int getRawRowIndex() {
        return this.rawRowIndex;
    }

    protected int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public Object[] next() {
        if (!this.hasNext()) {
            throw new CsvException("No more rows available");
        }
        ++this.rowIndex;
        Object[] rc = this.nextRow;
        this.nextRow = null;
        return rc;
    }

    @Override
    public void remove() {
        this.getReader().remove();
    }
}

