/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.impl.AbstractStreamTableWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.text.StringEscapeUtils;

public class XmlWriter
extends AbstractStreamTableWriter {
    private String topLevelTagName = "table";
    private String rowTagName = "record";
    private String columnTagName = "column";
    private boolean useColumnNameTags = false;
    private String columnNameAttribute = "name";
    private String columnTypeAttribute = "type";
    private boolean headerWritten = false;
    private String encoding = "UTF-8";
    private Object[] headerColumns = null;
    private boolean writeHeaderRow = false;

    public XmlWriter() {
    }

    public XmlWriter(OutputStream out) {
        this(out, false);
    }

    public XmlWriter(OutputStream out, boolean writeHeaderRow) {
        super(out);
        this.setWriteHeaderRow(writeHeaderRow);
    }

    public XmlWriter(File file) throws IOException {
        this(file, false);
    }

    public XmlWriter(File file, boolean writeHeaderRow) throws IOException {
        super(file);
        this.setWriteHeaderRow(writeHeaderRow);
    }

    public XmlWriter(String file) throws IOException {
        this(file, false);
    }

    public XmlWriter(String file, boolean writeHeaderRow) throws IOException {
        super(file);
        this.setWriteHeaderRow(writeHeaderRow);
    }

    @Override
    public void close() {
        this.printFooter();
        super.close();
    }

    @Override
    protected void init() {
        super.init();
        this.headerWritten = false;
        this.headerColumns = null;
    }

    @Override
    public void printRow(Object[] columns) throws IOException {
        if (!this.headerWritten) {
            this.printHeader();
        }
        if (this.isWriteHeaderRow() && this.getRowCount() == 0) {
            this.setHeaderColumns(columns);
        } else {
            this.getWriter().println("\t<" + this.getRowTagName() + ">");
            for (int i = 0; i < columns.length; ++i) {
                this.getWriter().print("\t\t" + this.getColumnStartTag(i, columns[i]));
                if (columns[i] == null) continue;
                this.getWriter().print(this.encode(this.convert(columns[i])));
                this.getWriter().println(this.getColumnEndTag(i));
            }
            this.getWriter().println("\t</" + this.getRowTagName() + ">");
        }
        this.incrementRowCount();
    }

    protected String getColumnStartTag(int column, Object value) {
        String tagName = this.getColumnTagName(column);
        String attributes = this.getColumnTagAttributes(column, value);
        StringBuilder rc = new StringBuilder();
        rc.append('<');
        rc.append(tagName);
        if (attributes != null) {
            rc.append(attributes);
        }
        if (value == null) {
            rc.append('/');
        }
        rc.append('>');
        return rc.toString();
    }

    protected String getColumnEndTag(int column) {
        String tagName = this.getColumnTagName(column);
        StringBuilder rc = new StringBuilder();
        rc.append("</");
        rc.append(tagName);
        rc.append('>');
        return rc.toString();
    }

    protected String getColumnTagName(int column) {
        if (!this.isUseColumnNameTags()) {
            return this.getColumnTagName();
        }
        return this.getColumnName(column);
    }

    protected String getColumnTagAttributes(int column, Object value) {
        StringBuilder rc = new StringBuilder();
        if (!this.isUseColumnNameTags()) {
            rc.append(' ');
            rc.append(this.getColumnNameAttribute());
            rc.append("=\"");
            rc.append(this.encode(this.getColumnName(column)));
            rc.append("\"");
        }
        if (value != null) {
            rc.append(' ');
            rc.append(this.getColumnTypeAttribute());
            rc.append("=\"");
            rc.append(this.encode(this.getColumnType(value)));
            rc.append("\"");
        }
        if (rc.length() > 0) {
            return rc.toString();
        }
        return null;
    }

    protected String getColumnType(Object value) {
        return value.getClass().getName();
    }

    @Override
    public void printComment(String comment) throws IOException {
        this.getWriter().println("<!--" + comment + "-->");
    }

    @Override
    public void printComment(String comment, int row, int column) throws IOException {
        this.printComment(comment);
    }

    protected void printHeader() {
        if (this.headerWritten) {
            return;
        }
        this.getWriter().println("<?xml version=\"1.0\" encoding=\"" + this.getEncoding() + "\"?>");
        this.getWriter().println("<" + this.getTopLevelTagName() + ">");
        this.headerWritten = true;
    }

    protected void printFooter() {
        if (!this.headerWritten) {
            this.printHeader();
        }
        this.getWriter().println("</" + this.getTopLevelTagName() + ">");
    }

    protected String encode(Object s) {
        return StringEscapeUtils.escapeXml11((String)s.toString());
    }

    protected String getColumnName(int index) {
        if (this.headerColumns == null || this.headerColumns.length <= index || this.headerColumns[index] == null) {
            return this.getDefaultColumnName(index);
        }
        return this.headerColumns[index].toString();
    }

    protected String getDefaultColumnName(int index) {
        return "column" + index;
    }

    public String getTopLevelTagName() {
        return this.topLevelTagName;
    }

    public void setTopLevelTagName(String topLevelTagName) {
        this.topLevelTagName = topLevelTagName;
    }

    public String getRowTagName() {
        return this.rowTagName;
    }

    public void setRowTagName(String rowTagName) {
        this.rowTagName = rowTagName;
    }

    public String getColumnTagName() {
        return this.columnTagName;
    }

    public void setColumnTagName(String columnTagName) {
        this.columnTagName = columnTagName;
    }

    public boolean isUseColumnNameTags() {
        return this.useColumnNameTags;
    }

    public void setUseColumnNameTags(boolean useColumnNameTags) {
        this.useColumnNameTags = useColumnNameTags;
    }

    public String getColumnNameAttribute() {
        return this.columnNameAttribute;
    }

    public void setColumnNameAttribute(String columnNameAttribute) {
        this.columnNameAttribute = columnNameAttribute;
    }

    public String getColumnTypeAttribute() {
        return this.columnTypeAttribute;
    }

    public void setColumnTypeAttribute(String columnTypeAttribute) {
        this.columnTypeAttribute = columnTypeAttribute;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Object[] getHeaderColumns() {
        return this.headerColumns;
    }

    public void setHeaderColumns(Object[] headerColumns) {
        this.headerColumns = headerColumns;
    }

    public boolean isWriteHeaderRow() {
        return this.writeHeaderRow;
    }

    public void setWriteHeaderRow(boolean writeHeaderRow) {
        this.writeHeaderRow = writeHeaderRow;
    }
}

