/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.CsvException;
import csv.impl.AbstractTableReader;
import csv.util.CSVUtils;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JTableReader
extends AbstractTableReader {
    private boolean selectedOnly = true;
    private JTable table;
    private int[] rows = null;
    private int currentRowIndex = -1;
    private int rowCount = 0;

    public JTableReader(JTable table) {
        this(table, true);
    }

    public JTableReader(JTable table, boolean selectedOnly) {
        this.table = table;
        this.selectedOnly = selectedOnly;
        this.setHasHeaderRow(true);
        this.myInit();
    }

    private void myInit() {
        this.rowCount = this.getTable().getRowCount();
        if (this.isSelectedOnly()) {
            this.rows = this.table.getSelectedRows();
            if (this.rows != null && this.rows.length > 0) {
                this.rowCount = this.rows.length;
            }
        }
        this.currentRowIndex = -1;
    }

    @Override
    public void reset() {
        super.reset();
        this.myInit();
    }

    @Override
    public boolean hasNext() {
        return this.rowCount > this.currentRowIndex + 1;
    }

    @Override
    public Object[] next() {
        if (!this.hasNext()) {
            throw new CsvException("No more rows");
        }
        ++this.currentRowIndex;
        int rowIndex = this.currentRowIndex;
        if (this.isSelectedOnly()) {
            rowIndex = this.rows[this.currentRowIndex];
        }
        TableModel model = this.getTable().getModel();
        int columnCount = model.getColumnCount();
        ArrayList<Object> columns = new ArrayList<Object>();
        for (int i = 0; i < columnCount; ++i) {
            columns.add(model.getValueAt(rowIndex, i));
        }
        this.incrementRowCount();
        return CSVUtils.convertList(columns, this.getMinimumColumnCount());
    }

    @Override
    public void remove() {
        throw new CsvException("remove is not supprted");
    }

    @Override
    protected void readHeaderRow() {
        TableColumnModel cModel = this.getTable().getTableHeader().getColumnModel();
        int colLength = cModel.getColumnCount();
        String[] row = new String[colLength];
        for (int i = 0; i < colLength; ++i) {
            Object o = cModel.getColumn(i).getHeaderValue();
            row[i] = o != null ? o.toString() : null;
        }
        this.setHeaderRow(row);
    }

    public boolean isSelectedOnly() {
        return this.selectedOnly;
    }

    public JTable getTable() {
        return this.table;
    }
}

