/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.impl.AbstractStreamTableWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.text.StringEscapeUtils;

public class HtmlWriter
extends AbstractStreamTableWriter {
    public static final String DEFAULT_TABLE_TEMPLATE = "<table>\n|</table>\n";
    public static final String DEFAULT_THEAD_TEMPLATE = "\t<thead>\n|\t</thead>\n";
    public static final String DEFAULT_THEAD_TR_TEMPLATE = "\t\t<tr>\n|\t\t</tr>\n";
    public static final String DEFAULT_THEAD_TH_TEMPLATE = "\t\t\t<th class=\"even\">|</th>\n";
    public static final String DEFAULT_THEAD_TH_TEMPLATE2 = "\t\t\t<th class=\"odd\">|</th>\n";
    public static final String DEFAULT_TBODY_TEMPLATE = "\t<tbody>\n|\t</tbody>\n";
    public static final String DEFAULT_TBODY_TR_TEMPLATE = "\t\t<tr class=\"even\">\n|\t\t</tr>\n";
    public static final String DEFAULT_TBODY_TD_TEMPLATE = "\t\t\t<td class=\"even\">|</td>\n";
    public static final String DEFAULT_TBODY_TR_TEMPLATE2 = "\t\t<tr class=\"odd\">\n|\t\t</tr>\n";
    public static final String DEFAULT_TBODY_TD_TEMPLATE2 = "\t\t\t<td class=\"odd\">|</td>\n";
    private String tableTemplate = "<table>\n|</table>\n";
    private String headerTemplate = "\t<thead>\n|\t</thead>\n";
    private String headerRowTemplate = "\t\t<tr>\n|\t\t</tr>\n";
    private String headerColumnTemplate = "\t\t\t<th class=\"even\">|</th>\n";
    private String headerColumnTemplate2 = "\t\t\t<th class=\"odd\">|</th>\n";
    private String bodyTemplate = "\t<tbody>\n|\t</tbody>\n";
    private String bodyRowTemplate = "\t\t<tr class=\"even\">\n|\t\t</tr>\n";
    private String bodyRowTemplate2 = "\t\t<tr class=\"odd\">\n|\t\t</tr>\n";
    private String dataColumnTemplate = "\t\t\t<td class=\"even\">|</td>\n";
    private String dataColumnTemplate2 = "\t\t\t<td class=\"odd\">|</td>\n";
    private boolean tableHeaderWritten = false;
    private boolean tableBodyHeaderWritten = false;
    private int currentRowIndex = 0;
    private boolean hasHeaderRow = true;

    public HtmlWriter() {
    }

    public HtmlWriter(OutputStream out) {
        super(out);
    }

    public HtmlWriter(File file) throws IOException {
        super(file);
    }

    public HtmlWriter(String file) throws IOException {
        super(file);
    }

    @Override
    public void close() {
        this.printTableBodyFooter();
        this.printTableFooter();
        super.close();
    }

    @Override
    protected void init() {
        this.currentRowIndex = 0;
        this.tableHeaderWritten = false;
        super.init();
    }

    @Override
    public void printRow(Object[] columns) throws IOException {
        this.printTableHeader();
        if (this.getRowCount() == 0 && this.isHasHeaderRow()) {
            this.printTableHeadHeader();
            this.printHeaderRow(columns);
            this.printTableHeadFooter();
        } else {
            this.printTableBodyHeader();
            this.printDataRow(columns, this.currentRowIndex);
            ++this.currentRowIndex;
        }
        this.incrementRowCount();
        this.getWriter().flush();
    }

    public void printHeaderRow(Object[] columns) {
        this.printTableHeadRowHeader();
        for (int i = 0; i < columns.length; ++i) {
            this.printTableHeadColumnHeader(i);
            this.printColumnContent(columns[i], -1, i);
            this.printTableHeadColumnFooter(i);
        }
        this.printTableHeadRowFooter();
    }

    public void printDataRow(Object[] columns, int rowIndex) {
        this.printTableBodyRowHeader(rowIndex);
        for (int i = 0; i < columns.length; ++i) {
            this.printTableDataColumnHeader(rowIndex, i);
            this.printColumnContent(columns[i], rowIndex, i);
            this.printTableDataColumnFooter(rowIndex, i);
        }
        this.printTableBodyRowFooter(rowIndex);
    }

    public void printColumnContent(Object o, int rowIndex, int columnIndex) {
        String s = this.convert(o);
        if ((s = HtmlWriter.encodeHtml(s)) == null || s.length() == 0) {
            s = "&nbsp;";
        }
        this.getWriter().print(s);
    }

    public void printTableHeader() {
        if (this.isTableHeaderWritten()) {
            return;
        }
        this.getWriter().print(HtmlWriter.getHeader(this.getTableTemplate()));
        this.tableHeaderWritten = true;
    }

    public void printTableFooter() {
        if (!this.tableHeaderWritten) {
            return;
        }
        this.getWriter().print(HtmlWriter.getFooter(this.getTableTemplate()));
        this.getWriter().flush();
    }

    public void printTableHeadHeader() {
        this.getWriter().print(HtmlWriter.getHeader(this.getTheadTemplate()));
    }

    public void printTableHeadFooter() {
        this.getWriter().print(HtmlWriter.getFooter(this.getTheadTemplate()));
    }

    public void printTableBodyHeader() {
        if (this.tableBodyHeaderWritten) {
            return;
        }
        this.getWriter().print(HtmlWriter.getHeader(this.getTbodyTemplate()));
        this.tableBodyHeaderWritten = true;
    }

    public void printTableBodyFooter() {
        if (!this.tableBodyHeaderWritten) {
            return;
        }
        this.getWriter().print(HtmlWriter.getFooter(this.getTbodyTemplate()));
    }

    public void printTableHeadRowHeader() {
        this.getWriter().print(HtmlWriter.getHeader(this.getTheadTrTemplate()));
    }

    public void printTableHeadRowFooter() {
        this.getWriter().print(HtmlWriter.getFooter(this.getTheadTrTemplate()));
    }

    public void printTableHeadColumnHeader(int columnIndex) {
        boolean even = columnIndex % 2 == 0;
        this.getWriter().print(HtmlWriter.getHeader(even ? this.getTheadThTemplate() : this.getTheadThTemplate2()));
    }

    public void printTableHeadColumnFooter(int columnIndex) {
        boolean even = columnIndex % 2 == 0;
        this.getWriter().print(HtmlWriter.getFooter(even ? this.getTheadThTemplate() : this.getTheadThTemplate2()));
    }

    public void printTableBodyRowHeader(int rowIndex) {
        boolean even = rowIndex % 2 == 0;
        this.getWriter().print(HtmlWriter.getHeader(even ? this.getTbodyTrTemplate() : this.getTbodyTrTemplate2()));
    }

    public void printTableBodyRowFooter(int rowIndex) {
        boolean even = rowIndex % 2 == 0;
        this.getWriter().print(HtmlWriter.getFooter(even ? this.getTbodyTrTemplate() : this.getTbodyTrTemplate2()));
    }

    public void printTableDataColumnHeader(int rowIndex, int columnIndex) {
        boolean even = columnIndex % 2 == 0;
        this.getWriter().print(HtmlWriter.getHeader(even ? this.getTbodyTdTemplate() : this.getTbodyTdTemplate2()));
    }

    public void printTableDataColumnFooter(int rowIndex, int columnIndex) {
        boolean even = columnIndex % 2 == 0;
        this.getWriter().print(HtmlWriter.getFooter(even ? this.getTbodyTdTemplate() : this.getTbodyTdTemplate2()));
    }

    public String getTableTemplate() {
        return this.tableTemplate;
    }

    public void setTableTemplate(String tableTemplate) {
        this.tableTemplate = tableTemplate;
    }

    public String getTheadTemplate() {
        return this.headerTemplate;
    }

    public void setTheadTemplate(String headerTemplate) {
        this.headerTemplate = headerTemplate;
    }

    public String getTheadTrTemplate() {
        return this.headerRowTemplate;
    }

    public void setTheadTrTemplate(String headerRowTemplate) {
        this.headerRowTemplate = headerRowTemplate;
    }

    public String getTheadThTemplate() {
        return this.headerColumnTemplate;
    }

    public void setTheadThTemplate(String headerColumnTemplate) {
        this.headerColumnTemplate = headerColumnTemplate;
    }

    public String getTheadThTemplate2() {
        return this.headerColumnTemplate2;
    }

    public void setTheadThTemplate2(String headerColumnTemplate2) {
        this.headerColumnTemplate2 = headerColumnTemplate2;
    }

    public String getTbodyTemplate() {
        return this.bodyTemplate;
    }

    public void setTbodyTemplate(String bodyTemplate) {
        this.bodyTemplate = bodyTemplate;
    }

    public String getTbodyTrTemplate() {
        return this.bodyRowTemplate;
    }

    public void setTbodyTrTemplate(String bodyRowTemplate) {
        this.bodyRowTemplate = bodyRowTemplate;
    }

    public String getTbodyTrTemplate2() {
        return this.bodyRowTemplate2;
    }

    public void setTbodyTrTemplate2(String bodyRowTemplate2) {
        this.bodyRowTemplate2 = bodyRowTemplate2;
    }

    public String getTbodyTdTemplate() {
        return this.dataColumnTemplate;
    }

    public void setTbodyTdTemplate(String dataColumnTemplate) {
        this.dataColumnTemplate = dataColumnTemplate;
    }

    public String getTbodyTdTemplate2() {
        return this.dataColumnTemplate2;
    }

    public void setTbodyTdTemplate2(String dataColumnTemplate2) {
        this.dataColumnTemplate2 = dataColumnTemplate2;
    }

    public boolean isTableHeaderWritten() {
        return this.tableHeaderWritten;
    }

    public int getCurrentRowIndex() {
        return this.currentRowIndex;
    }

    public boolean isHasHeaderRow() {
        return this.hasHeaderRow;
    }

    public void setHasHeaderRow(boolean hasHeaderRow) {
        this.hasHeaderRow = hasHeaderRow;
    }

    public static String encodeHtml(String s) {
        if (s == null) {
            return null;
        }
        return StringEscapeUtils.escapeHtml4((String)s);
    }

    protected static String getHeader(String template) {
        if (template == null) {
            return null;
        }
        String[] s = template.split("\\|", 2);
        if (s.length == 0) {
            return null;
        }
        return s[0];
    }

    protected static String getFooter(String template) {
        if (template == null) {
            return null;
        }
        String[] s = template.split("\\|", 2);
        if (s.length == 0) {
            return null;
        }
        if (s.length == 1) {
            return "";
        }
        return s[1];
    }
}

