/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.impl.AbstractStreamTableWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class CSVWriter
extends AbstractStreamTableWriter {
    private String columnDelimiter = "\"";
    private char columnSeparator = (char)59;
    private boolean delimiterRequired = false;
    private String rowSeparator = "\n";
    private int columnCount = 0;
    private char commentChar = (char)35;
    private PrintWriter argWriter;

    public CSVWriter() {
    }

    public CSVWriter(File file) throws IOException {
        super(file);
    }

    public CSVWriter(OutputStream out) {
        super(out);
    }

    @Deprecated
    public CSVWriter(Writer out) {
        this.argWriter = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
    }

    @Deprecated
    public CSVWriter(Writer out, boolean flush) {
        this(out);
    }

    public CSVWriter(String file) throws IOException {
        super(file);
    }

    @Override
    protected void init() {
        super.init();
        this.columnCount = 0;
    }

    @Override
    public PrintWriter getWriter() {
        if (this.argWriter != null) {
            return this.argWriter;
        }
        return super.getWriter();
    }

    @Override
    public void close() {
        if (this.argWriter != null) {
            this.argWriter.close();
        }
        super.close();
    }

    public void setColumnDelimiter(String s) {
        this.columnDelimiter = s;
    }

    public String getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public void setColumnSeparator(char s) {
        this.columnSeparator = s;
    }

    public char getColumnSeparator() {
        return this.columnSeparator;
    }

    public void setRowSeparator(String s) {
        this.rowSeparator = s;
    }

    public String getRowSeparator() {
        return this.rowSeparator;
    }

    public void setColumnDelimiterRequired(boolean b) {
        this.delimiterRequired = b;
    }

    public boolean isColumnDelimiterRequired() {
        return this.delimiterRequired;
    }

    public char getCommentChar() {
        return this.commentChar;
    }

    public void setCommentChar(char commentChar) {
        this.commentChar = commentChar;
    }

    public String prepareRow(Object[] columns) {
        StringBuilder rc = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            Object o = columns[i];
            if (i != 0) {
                rc.append(this.getColumnSeparator());
            }
            rc.append(this.prepareColumn(o));
        }
        if (this.columnCount < columns.length) {
            this.columnCount = columns.length;
        }
        rc.append(this.rowSeparator);
        return rc.toString();
    }

    @Override
    public void printRow(Object[] columns) throws IOException {
        this.getWriter().print(this.prepareRow(columns));
        this.getWriter().flush();
        this.incrementRowCount();
    }

    public String prepareComment(String comment) {
        StringBuilder s = new StringBuilder();
        s.append(this.getCommentChar());
        s.append(' ');
        s.append(comment);
        s.append(this.getRowSeparator());
        return s.toString();
    }

    @Override
    public void printComment(String comment) throws IOException {
        this.printComment(comment, 0, 0);
    }

    @Override
    public void printComment(String comment, int row, int column) throws IOException {
        this.getWriter().print(this.prepareComment(comment));
        this.getWriter().flush();
    }

    private String prepareColumn(Object o) {
        Object rc = "";
        if (o == null) {
            return rc;
        }
        String s = this.convert(o);
        if (this.columnDelimiter != null && this.columnNeedsDelimiting(s)) {
            rc = this.columnDelimiter;
            rc = (String)rc + this.prepareColumnValue(s);
            rc = (String)rc + this.columnDelimiter;
        } else {
            rc = s;
        }
        return rc;
    }

    protected boolean columnNeedsDelimiting(String s) {
        if (this.delimiterRequired) {
            return true;
        }
        if (s == null || s.length() == 0) {
            return false;
        }
        if (!s.trim().equals(s)) {
            return true;
        }
        if (s.charAt(0) == this.getCommentChar()) {
            return true;
        }
        if (s.indexOf(this.rowSeparator) >= 0) {
            return true;
        }
        if (s.indexOf(this.columnSeparator) >= 0) {
            return true;
        }
        if (s.startsWith("ID") && this.getRowCount() == 0) {
            return true;
        }
        return s.indexOf(this.columnDelimiter) >= 0;
    }

    protected String prepareColumnValue(String s) {
        if (this.columnDelimiter != null) {
            s = s.replaceAll(this.columnDelimiter, this.columnDelimiter + this.columnDelimiter);
        }
        return s;
    }

    public int getColumnCount() {
        return this.columnCount;
    }
}

