/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.CommentCallback;
import csv.CsvException;
import csv.TableReader;
import csv.TypeConversionHandler;
import csv.impl.type.BooleanConversionHandler;
import csv.impl.type.ByteConversionHandler;
import csv.impl.type.CharConversionHandler;
import csv.impl.type.DateConversionHandler;
import csv.impl.type.DoubleConversionHandler;
import csv.impl.type.FloatConversionHandler;
import csv.impl.type.IntegerConversionHandler;
import csv.impl.type.LongConversionHandler;
import csv.impl.type.ShortConversionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractTableReader
implements TableReader {
    private List<CommentCallback> commentCallbacks = new ArrayList<CommentCallback>();
    private int rowCount = 0;
    private int lineCount = 0;
    private boolean hasHeaderRow = false;
    private Object[] headerRow = null;
    private boolean headerRowRead = false;
    private int minimumColumnCount = 0;
    private Map<String, TypeConversionHandler> typeConversionHandlers = new HashMap<String, TypeConversionHandler>();
    private Map<Integer, String> columnTypes = new HashMap<Integer, String>();

    public AbstractTableReader() {
        this.registerTypeConversionHandler(BooleanConversionHandler.INSTANCE);
        this.registerTypeConversionHandler(ByteConversionHandler.INSTANCE);
        this.registerTypeConversionHandler(CharConversionHandler.INSTANCE);
        this.registerTypeConversionHandler(DoubleConversionHandler.INSTANCE);
        this.registerTypeConversionHandler(FloatConversionHandler.INSTANCE);
        this.registerTypeConversionHandler(IntegerConversionHandler.INSTANCE);
        this.registerTypeConversionHandler(LongConversionHandler.INSTANCE);
        this.registerTypeConversionHandler(ShortConversionHandler.INSTANCE);
        this.registerTypeConversionHandler(DateConversionHandler.INSTANCE);
    }

    @Override
    public void open() {
        this.rowCount = 0;
        this.lineCount = 0;
        this.headerRow = null;
        this.setHeaderRowRead(false);
    }

    @Override
    public void reset() {
        this.rowCount = 0;
        this.lineCount = 0;
        this.headerRow = null;
        this.setHeaderRowRead(false);
    }

    @Override
    public Object[] getHeaderRow() {
        if (!this.hasHeaderRow()) {
            return null;
        }
        if (!this.isHeaderRowRead()) {
            this.readHeaderRow();
        }
        return this.headerRow;
    }

    protected void readHeaderRow() {
    }

    protected void setHeaderRow(String[] names) {
        this.setHeaderRowRead(true);
        this.headerRow = names;
    }

    protected void setHeaderRowRead(boolean headerRowRead) {
        this.headerRowRead = headerRowRead;
    }

    public Object get(String name, Object[] row) {
        if (row == null) {
            return null;
        }
        int column = this.getColumnIndex(name);
        if (column < 0 || column >= row.length) {
            return null;
        }
        return row[column];
    }

    @Override
    public int getColumnIndex(String name) {
        if (!this.hasHeaderRow()) {
            throw new CsvException("TableReader has no header row (property hasHeaderRow is false)");
        }
        this.readHeaderRow();
        if (this.getHeaderRow() == null) {
            throw new CsvException("Stream is empty");
        }
        for (int i = 0; i < this.headerRow.length; ++i) {
            if (this.headerRow[i] == null || !this.headerRow[i].toString().equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public void setColumnType(int columnIndex, Class<?> type) {
        this.columnTypes.put(columnIndex, type.getName());
    }

    public String getColumnType(int columnIndex) {
        String rc = this.columnTypes.get(columnIndex);
        if (rc == null) {
            rc = "java.lang.String";
        }
        return rc;
    }

    @Override
    public boolean hasHeaderRow() {
        return this.hasHeaderRow;
    }

    @Override
    public void setHasHeaderRow(boolean hasHeaderRow) {
        this.hasHeaderRow = hasHeaderRow;
    }

    @Deprecated
    public void addCommentCallBack(CommentCallback callback) {
        this.commentCallbacks.add(callback);
    }

    @Override
    public void registerCommentCallBack(CommentCallback callback) {
        this.commentCallbacks.add(callback);
    }

    @Deprecated
    public void removeCommentCallBack(CommentCallback callback) {
        this.commentCallbacks.remove(callback);
    }

    @Override
    public void unregisterCommentCallBack(CommentCallback callback) {
        this.commentCallbacks.remove(callback);
    }

    @Override
    public Iterator<Object[]> iterator() {
        return this;
    }

    protected void notifyComment(String s, int row, int cell) {
        for (CommentCallback callback : this.commentCallbacks) {
            callback.comment(this, s, row, cell);
        }
    }

    public void registerTypeConversionHandler(TypeConversionHandler handler) {
        for (String type : handler.getTypes()) {
            this.typeConversionHandlers.put(type, handler);
        }
    }

    public void unregisterTypeConversionHandler(TypeConversionHandler handler) {
        for (String type : handler.getTypes()) {
            this.typeConversionHandlers.remove(type);
        }
    }

    protected Object convert(int columnIndex, String value) {
        String columnType = this.getColumnType(columnIndex);
        if (columnType == null) {
            columnType = "java.lang.String";
        }
        return this.convert(columnType, value);
    }

    protected Object convert(String type, String value) {
        if (value == null) {
            return null;
        }
        TypeConversionHandler handler = this.getTypeConversionHandler(type);
        if (handler != null) {
            return handler.toObject(value);
        }
        return value;
    }

    protected TypeConversionHandler getTypeConversionHandler(String type) {
        return this.typeConversionHandlers.get(type);
    }

    protected int incrementLineCount() {
        ++this.lineCount;
        return this.getLineCount();
    }

    public int getLineCount() {
        return this.lineCount;
    }

    protected int incrementRowCount() {
        ++this.rowCount;
        return this.getRowCount();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public void close() {
    }

    @Override
    public void setMinimumColumnCount(int length) {
        this.minimumColumnCount = length;
    }

    @Override
    public int getMinimumColumnCount() {
        return this.minimumColumnCount;
    }

    protected Object[] convertArray(List<String> columns) {
        int colcount = columns != null ? columns.size() : 0;
        Object[] rc = new Object[Math.max(colcount, this.getMinimumColumnCount())];
        if (columns != null && colcount > 0) {
            for (int i = 0; i < colcount; ++i) {
                rc[i] = this.convert(i, columns.get(i));
            }
        }
        return rc;
    }

    protected Object[] convertArray(String[] columns) {
        int colcount = this.getMinimumColumnCount();
        if (columns != null) {
            colcount = columns.length;
        }
        Object[] rc = new Object[Math.max(colcount, this.getMinimumColumnCount())];
        if (columns != null && colcount > 0) {
            for (int i = 0; i < colcount; ++i) {
                rc[i] = this.convert(i, columns[i]);
            }
        }
        return rc;
    }

    public boolean isHeaderRowRead() {
        return this.headerRowRead;
    }
}

