/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.CsvException;
import csv.impl.AbstractTableWriter;
import csv.util.CSVUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public abstract class AbstractStreamTableWriter
extends AbstractTableWriter {
    private PrintWriter writer;
    private OutputStream outputStream;
    private CharsetEncoder charsetEncoder = CSVUtils.getDefaultCharset().newEncoder();

    public AbstractStreamTableWriter() {
        this.init();
    }

    public AbstractStreamTableWriter(OutputStream out) {
        this.setOutputStream(out);
        this.init();
    }

    public AbstractStreamTableWriter(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    public AbstractStreamTableWriter(String file) throws IOException {
        this(new FileOutputStream(file));
    }

    public void setOutputStream(OutputStream out) {
        if (this.outputStream != null) {
            throw new CsvException("Output stream already set");
        }
        this.outputStream = out;
    }

    public PrintWriter getWriter() {
        if (this.writer == null) {
            this.writer = this.createWriter();
        }
        return this.writer;
    }

    protected PrintWriter createWriter() {
        return new PrintWriter(this.createOutputStreamWriter(this.getOutputStream()));
    }

    protected OutputStreamWriter createOutputStreamWriter(OutputStream out) {
        return new OutputStreamWriter(out, this.getCharsetEncoder());
    }

    public CharsetEncoder getCharsetEncoder() {
        return this.charsetEncoder;
    }

    public void setCharsetEncoder(CharsetEncoder charsetEncoder) {
        this.charsetEncoder = charsetEncoder;
    }

    public void setCharset(Charset charset) {
        this.setCharsetEncoder(charset.newEncoder());
    }

    public void setCharset(String charset) {
        this.setCharset(Charset.forName(charset));
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void close() {
        try {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
            }
            if (this.getOutputStream() != null) {
                this.getOutputStream().flush();
                this.getOutputStream().close();
            }
        }
        catch (IOException e) {
            throw new CsvException("Cannot close writer", e);
        }
        super.close();
    }
}

