/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import rs.baselib.util.RsDate;

public class RsYear
extends RsDate {
    private static final long serialVersionUID = 1L;

    private static SimpleDateFormat KEY_PARSER() {
        return new SimpleDateFormat("yyyy");
    }

    public RsYear() {
        this(TimeZone.getDefault());
    }

    public RsYear(TimeZone timezone) {
        super(timezone != null ? timezone : TimeZone.getDefault());
        this.ensureBegin();
    }

    public RsYear(Date date) {
        super(date);
        this.ensureBegin();
    }

    public RsYear(TimeZone timezone, Date date) {
        super(timezone, date);
        this.ensureBegin();
    }

    public RsYear(long timeInMillis) {
        super(timeInMillis);
        this.ensureBegin();
    }

    public RsYear(TimeZone timezone, long timeInMillis) {
        super(timezone, timeInMillis);
        this.ensureBegin();
    }

    public RsYear(Calendar calendar) {
        super(calendar);
        this.ensureBegin();
    }

    public RsYear(int year) {
        this(TimeZone.getDefault(), year);
    }

    public RsYear(TimeZone timezone, int year) {
        super(timezone, 0L);
        this.set(1, year);
        this.ensureBegin();
    }

    protected void ensureBegin() {
        this.set(2, 0);
        this.set(5, 1);
        this.set(11, 0);
        this.set(12, 0);
        this.set(13, 0);
        this.set(14, 0);
        this.getKey();
    }

    public String getKey() {
        StringBuffer rc = new StringBuffer();
        rc.append(this.get(1));
        return rc.toString();
    }

    public int getIntKey() {
        return this.get(1);
    }

    public RsDate getBegin() {
        RsDate rc = new RsDate(this.getTimeZone(), this.getTimeInMillis());
        rc.set(5, 1);
        rc.set(2, 0);
        rc.set(11, 0);
        rc.set(12, 0);
        rc.set(13, 0);
        rc.set(14, 0);
        return rc;
    }

    public RsDate getEnd() {
        RsDate rc = new RsDate(this.getTimeZone(), this.getTimeInMillis());
        rc.set(5, rc.getActualMaximum(5));
        rc.set(2, rc.getActualMaximum(2));
        rc.set(11, rc.getActualMaximum(11));
        rc.set(12, rc.getActualMaximum(12));
        rc.set(13, rc.getActualMaximum(13));
        rc.set(14, rc.getActualMaximum(14));
        return rc;
    }

    public RsYear getNext() {
        RsYear rc = new RsYear(this.getTimeZone(), this.getTimeInMillis());
        rc.add(1, 1);
        return rc;
    }

    public RsYear getPrevious() {
        RsYear rc = new RsYear(this.getTimeZone(), this.getTimeInMillis());
        rc.add(1, -1);
        return rc;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof RsYear)) {
            return false;
        }
        RsYear m = (RsYear)o;
        return this.getKey().equals(m.getKey());
    }

    @Override
    public int hashCode() {
        return this.getKey().hashCode();
    }

    @Override
    public String toString() {
        return this.getKey();
    }

    public static RsYear getYear(String key) {
        try {
            return new RsYear(RsYear.KEY_PARSER().parse(key));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse month: " + key, e);
        }
    }

    public static RsYear getYear(int year) {
        return new RsYear(year);
    }
}

