/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import rs.baselib.util.RsDate;

public class RsDay
extends RsDate {
    private static final long serialVersionUID = 1L;

    private static SimpleDateFormat KEY_PARSER() {
        return new SimpleDateFormat("yyyyMMdd");
    }

    public RsDay() {
        this(TimeZone.getDefault());
    }

    public RsDay(TimeZone timezone) {
        super(timezone);
        this.ensureBegin();
    }

    public RsDay(Date date) {
        super(date);
        this.ensureBegin();
    }

    public RsDay(TimeZone timezone, Date date) {
        super(timezone, date);
        this.ensureBegin();
    }

    public RsDay(long timeInMillis) {
        super(timeInMillis);
        this.ensureBegin();
    }

    public RsDay(TimeZone timezone, long timeInMillis) {
        super(timezone, timeInMillis);
        this.ensureBegin();
    }

    public RsDay(Calendar calendar) {
        super(calendar);
        this.ensureBegin();
    }

    public RsDay(int day, int month, int year) {
        this(TimeZone.getDefault(), day, month, year);
    }

    public RsDay(TimeZone timezone, int day, int month, int year) {
        super(timezone, 0L);
        this.set(5, day);
        this.set(2, month);
        this.set(1, year);
        this.ensureBegin();
    }

    protected void ensureBegin() {
        this.set(11, 0);
        this.set(12, 0);
        this.set(13, 0);
        this.set(14, 0);
        this.getKey();
    }

    public String getKey() {
        StringBuffer rc = new StringBuffer();
        rc.append(this.get(1));
        int m = this.get(2);
        if (m < 9) {
            rc.append('0');
        }
        rc.append(m + 1);
        int d = this.get(5);
        if (d < 10) {
            rc.append('0');
        }
        rc.append(d);
        return rc.toString();
    }

    public RsDate getBegin() {
        RsDate rc = new RsDate(this.getTimeZone(), this.getTimeInMillis());
        rc.set(11, 0);
        rc.set(12, 0);
        rc.set(13, 0);
        rc.set(14, 0);
        return rc;
    }

    public RsDate getEnd() {
        RsDate rc = new RsDate(this.getTimeZone(), this.getTimeInMillis());
        rc.set(11, rc.getActualMaximum(11));
        rc.set(12, rc.getActualMaximum(12));
        rc.set(13, rc.getActualMaximum(13));
        rc.set(14, rc.getActualMaximum(14));
        return rc;
    }

    public RsDay getNext() {
        RsDay rc = new RsDay(this.getTimeZone(), this.getTimeInMillis());
        rc.add(5, 1);
        return rc;
    }

    public RsDay getPrevious() {
        RsDay rc = new RsDay(this.getTimeZone(), this.getTimeInMillis());
        rc.add(5, -1);
        return rc;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof RsDay)) {
            return false;
        }
        RsDay m = (RsDay)o;
        return this.getKey().equals(m.getKey());
    }

    @Override
    public int hashCode() {
        return this.getKey().hashCode();
    }

    @Override
    public String toString() {
        return this.getKey();
    }

    public static RsDay getDay(String key) {
        try {
            return new RsDay(RsDay.KEY_PARSER().parse(key));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse day: " + key, e);
        }
    }
}

