/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.util;

import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import rs.baselib.util.RsDay;
import rs.baselib.util.RsMonth;
import rs.baselib.util.RsYear;

public class RsDate
extends GregorianCalendar {
    private static final long serialVersionUID = 1L;

    public RsDate() {
        this(TimeZone.getDefault());
    }

    public RsDate(TimeZone timezone) {
        super(timezone != null ? timezone : TimeZone.getDefault());
    }

    public RsDate(Date date) {
        this(TimeZone.getDefault(), date);
    }

    public RsDate(TimeZone timezone, Date date) {
        this.setTimeZone(timezone != null ? timezone : TimeZone.getDefault());
        if (date != null) {
            this.setTimeInMillis(date.getTime());
        } else {
            this.setTimeInMillis(0L);
        }
    }

    public RsDate(long timeInMillis) {
        this(TimeZone.getDefault(), timeInMillis);
    }

    public RsDate(TimeZone timezone, long timeInMillis) {
        super(timezone != null ? timezone : TimeZone.getDefault());
        this.setTimeInMillis(timeInMillis);
    }

    public RsDate(Calendar calendar) {
        if (calendar == null) {
            calendar = new RsDate();
        }
        this.setTimeInMillis(calendar.getTimeInMillis());
        this.setTimeZone(calendar.getTimeZone());
        this.get(5);
    }

    public RsDate(int year, int month, int dayOfMonth) {
        this(TimeZone.getDefault(), year, month, dayOfMonth, 0, 0, 0, 0);
    }

    public RsDate(TimeZone timezone, int year, int month, int dayOfMonth) {
        this(timezone, year, month, dayOfMonth, 0, 0, 0, 0);
    }

    public RsDate(int year, int month, int dayOfMonth, int hourOfDay, int minute) {
        this(TimeZone.getDefault(), year, month, dayOfMonth, hourOfDay, minute, 0, 0);
    }

    public RsDate(TimeZone timezone, int year, int month, int dayOfMonth, int hourOfDay, int minute) {
        this(timezone, year, month, dayOfMonth, hourOfDay, minute, 0, 0);
    }

    public RsDate(int year, int month, int dayOfMonth, int hourOfDay, int minute, int seconds) {
        this(TimeZone.getDefault(), year, month, dayOfMonth, hourOfDay, minute, seconds, 0);
    }

    public RsDate(TimeZone timezone, int year, int month, int dayOfMonth, int hourOfDay, int minute, int seconds) {
        this(timezone, year, month, dayOfMonth, hourOfDay, minute, seconds, 0);
    }

    public RsDate(int year, int month, int dayOfMonth, int hourOfDay, int minute, int seconds, int milliseconds) {
        this(TimeZone.getDefault(), year, month, dayOfMonth, hourOfDay, minute, seconds, milliseconds);
    }

    public RsDate(TimeZone timezone, int year, int month, int dayOfMonth, int hourOfDay, int minute, int seconds, int milliseconds) {
        this.setTimeZone(timezone != null ? timezone : TimeZone.getDefault());
        this.set(1, year);
        this.set(2, month);
        this.set(5, dayOfMonth);
        this.set(11, hourOfDay);
        this.set(12, minute);
        this.set(13, seconds);
        this.set(14, milliseconds);
    }

    public RsYear getYear() {
        return new RsYear(this.getTimeZone(), this.getTimeInMillis());
    }

    public RsMonth getMonth() {
        return new RsMonth(this.getTimeZone(), this.getTimeInMillis());
    }

    public RsDay getDay() {
        return new RsDay(this.getTimeZone(), this.getTimeInMillis());
    }

    public static RsDate get(Date date) {
        if (date == null) {
            return null;
        }
        return RsDate.get(date.getTime());
    }

    public static RsDate get(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return RsDate.get(timestamp.getTime());
    }

    public static RsDate get(long timestamp) {
        if (timestamp == 0L) {
            return null;
        }
        return new RsDate(timestamp);
    }

    @Override
    public String toString() {
        return "RsDate [" + this.toZonedDateTime().format(DateTimeFormatter.ISO_ZONED_DATE_TIME) + "]";
    }
}

