/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.baselib.lang.JarDescriptor;
import rs.baselib.lang.ResourceList;
import rs.baselib.util.LogLevel;
import rs.baselib.util.ReleaseInformation;

public class ReleaseRepository {
    private static Logger log = LoggerFactory.getLogger(ReleaseRepository.class);
    private static Pattern POM_PROPERTIES_PATTERN = Pattern.compile("META-INF\\/maven\\/([^\\/]+)\\/([^\\/]+)\\/pom\\.properties");
    private static Pattern JAR_FILE_PATTERN = Pattern.compile("(.+)-([\\.\\d]+)\\.jar");
    public static ReleaseRepository INSTANCE = new ReleaseRepository();
    public static final String BASELIB_GROUP_ID = "eu.ralph-schuster";
    public static final String BASELIB_ARTIFACT_ID = "baselib";
    public static final String BUNDLE_ARTIFACT_ID = "lib-bundle";
    private Properties properties = new Properties();
    private Map<String, Map<String, Map<String, ReleaseInformation>>> releaseInformation = new HashMap<String, Map<String, Map<String, ReleaseInformation>>>();

    public ReleaseRepository() {
        try {
            Collection<JarDescriptor> descs = ResourceList.getJars();
            for (JarDescriptor desc : descs) {
                this.addJar(desc);
            }
            Collection<File> dirs = ResourceList.getDirectories();
            for (File dir : dirs) {
                if (this.addProperties(new File(dir, "build.properties"))) continue;
                this.addProperties(new File(dir, "WEB-INF/classes/build.properties"));
            }
        }
        catch (IOException e) {
            log.error("Cannot load baselib version information: ", (Throwable)e);
        }
    }

    private void addJar(JarDescriptor desc) throws IOException {
        String file;
        Attributes attr2;
        Manifest manifest = desc.getManifest();
        boolean added = false;
        if (manifest != null && (attr2 = manifest.getAttributes("eu.ralph-schuster.baselib")) != null && (file = attr2.getValue("Package-File")) != null) {
            added = this.addBuildProperties(new URL(desc.getUrlPrefix() + file));
        }
        if (!added) {
            try {
                added = desc.getFile().getName().endsWith("war") ? this.addBuildProperties(new URL(desc.getUrlPrefix() + "WEB-INF/classes/build.properties")) : this.addBuildProperties(new URL(desc.getUrlPrefix() + "build.properties"));
            }
            catch (IOException attr2) {
                // empty catch block
            }
        }
        if (!added) {
            try {
                Enumeration<JarEntry> e = desc.getJarFile().entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    Matcher m = POM_PROPERTIES_PATTERN.matcher(entry.getName());
                    if (!m.matches()) continue;
                    added = this.addPomProperties(new URL(desc.getUrlPrefix() + entry.getName()));
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!added && manifest != null) {
            try {
                attr2 = manifest.getMainAttributes();
                if (attr2 != null) {
                    String version;
                    String artifactId;
                    String groupId = attr2.getValue("Implementation-Vendor-Id");
                    added = this.addReleaseInformation(groupId, artifactId = attr2.getValue("Implementation-Title"), version = attr2.getValue("Implementation-Version"), groupId + ":" + artifactId) != null;
                }
            }
            catch (Exception attr3) {
                // empty catch block
            }
        }
        if (!added) {
            try {
                String name = desc.getFile().getName();
                Matcher m = JAR_FILE_PATTERN.matcher(name);
                if (m.matches()) {
                    String groupId = m.group(1);
                    String artifactId = m.group(1);
                    String version = m.group(2);
                    this.addReleaseInformation(groupId, artifactId, version, groupId + ":" + artifactId);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addProperties(File file) throws IOException {
        boolean rc = false;
        if (file.exists() && file.canRead()) {
            try (FileInputStream in = new FileInputStream(file);){
                rc = this.addBuildProperties(in);
            }
        }
        return rc;
    }

    public boolean addBuildProperties(URL url) throws IOException {
        if (url == null) {
            return false;
        }
        InputStream in = url.openStream();
        boolean rc = this.addBuildProperties(in);
        in.close();
        return rc;
    }

    public boolean addBuildProperties(InputStream in) throws IOException {
        Properties newProps = new Properties();
        newProps.load(in);
        ReleaseInformation rc = this.addReleaseInformation(newProps);
        return rc != null;
    }

    public boolean addPomProperties(URL url) throws IOException {
        if (url == null) {
            return false;
        }
        InputStream in = url.openStream();
        boolean rc = this.addPomProperties(in);
        in.close();
        return rc;
    }

    public boolean addPomProperties(InputStream in) throws IOException {
        Properties newProps = new Properties();
        newProps.load(in);
        String groupId = newProps.getProperty("groupId");
        String artifactId = newProps.getProperty("artifactId");
        String version = newProps.getProperty("version");
        Properties buildProps = new Properties();
        buildProps.setProperty(groupId + "." + artifactId + ".groupId", groupId);
        buildProps.setProperty(groupId + "." + artifactId + ".artifactId", artifactId);
        buildProps.setProperty(groupId + "." + artifactId + ".version", version);
        buildProps.setProperty(groupId + "." + artifactId + ".name", groupId + ":" + artifactId);
        ReleaseInformation rc = this.addReleaseInformation(buildProps);
        return rc != null;
    }

    public ReleaseInformation addReleaseInformation(String groupId, String artifactId, String version, String name) {
        if (groupId != null && artifactId != null && version != null && name != null) {
            Properties buildProps = new Properties();
            buildProps.setProperty(groupId + "." + artifactId + ".groupId", groupId);
            buildProps.setProperty(groupId + "." + artifactId + ".artifactId", artifactId);
            buildProps.setProperty(groupId + "." + artifactId + ".version", version);
            buildProps.setProperty(groupId + "." + artifactId + ".name", name);
            return this.addReleaseInformation(buildProps);
        }
        return null;
    }

    public ReleaseInformation addReleaseInformation(Properties props) {
        ReleaseInformation rc = new ReleaseInformation();
        for (Object o : props.keySet()) {
            String key = (String)o;
            try {
                rc.set(key, props.getProperty(key));
                this.properties.setProperty(key, props.getProperty(key));
            }
            catch (ParseException e) {
                if (log != null) {
                    log.error("Cannot read \"" + key + "\": " + props.get(key), (Throwable)e);
                    continue;
                }
                System.out.println("Cannot read \"" + key + "\": " + props.get(key));
                e.printStackTrace(System.out);
            }
        }
        if (this.addReleaseInformation(rc)) {
            return rc;
        }
        return null;
    }

    public boolean addReleaseInformation(ReleaseInformation info) {
        Map<String, ReleaseInformation> artifactInfo;
        if (!info.isValid()) {
            return false;
        }
        Map<String, Map<String, ReleaseInformation>> groupInfo = this.releaseInformation.get(info.getGroupId());
        if (groupInfo == null) {
            groupInfo = new HashMap<String, Map<String, ReleaseInformation>>();
            this.releaseInformation.put(info.getGroupId(), groupInfo);
        }
        if ((artifactInfo = groupInfo.get(info.getArtifactId())) == null) {
            artifactInfo = new HashMap<String, ReleaseInformation>();
            groupInfo.put(info.getArtifactId(), artifactInfo);
        }
        artifactInfo.put(info.getVersion(), info);
        return true;
    }

    public Collection<String> getGroups() {
        return this.releaseInformation.keySet();
    }

    public ReleaseInformation getReleaseInformation(String groupId, String artifactId, String version) {
        Map<String, Map<String, ReleaseInformation>> groupInfo = this.releaseInformation.get(groupId);
        if (groupInfo == null) {
            return null;
        }
        Map<String, ReleaseInformation> artifactInfo = groupInfo.get(artifactId);
        if (artifactInfo == null) {
            return null;
        }
        return artifactInfo.get(version);
    }

    public Collection<ReleaseInformation> getAllInfos() {
        HashSet<ReleaseInformation> rc = new HashSet<ReleaseInformation>();
        for (String groupId : this.getGroups()) {
            for (String artifactId : this.getArtifacts(groupId)) {
                for (String version : this.getVersions(groupId, artifactId)) {
                    rc.add(this.getReleaseInformation(groupId, artifactId, version));
                }
            }
        }
        return rc;
    }

    public Collection<ReleaseInformation> getArtifactInfos(String groupId) {
        HashSet<ReleaseInformation> rc = new HashSet<ReleaseInformation>();
        Map<String, Map<String, ReleaseInformation>> groupInfo = this.releaseInformation.get(groupId);
        if (groupInfo == null) {
            return rc;
        }
        for (String artifactId : groupInfo.keySet()) {
            rc.addAll(this.getVersionInfos(groupId, artifactId));
        }
        return rc;
    }

    public Collection<ReleaseInformation> getVersionInfos(String groupId, String artifactId) {
        HashSet<ReleaseInformation> rc = new HashSet<ReleaseInformation>();
        Map<String, Map<String, ReleaseInformation>> groupInfo = this.releaseInformation.get(groupId);
        if (groupInfo == null) {
            return rc;
        }
        Map<String, ReleaseInformation> artifactInfo = groupInfo.get(artifactId);
        if (artifactInfo == null) {
            return rc;
        }
        rc.addAll(artifactInfo.values());
        return rc;
    }

    public Collection<String> getArtifacts(String groupId) {
        Map<String, Map<String, ReleaseInformation>> groupInfo = this.releaseInformation.get(groupId);
        if (groupInfo == null) {
            return Collections.emptySet();
        }
        return groupInfo.keySet();
    }

    public Collection<String> getVersions(String groupId, String artifactId) {
        Map<String, Map<String, ReleaseInformation>> groupInfo = this.releaseInformation.get(groupId);
        if (groupInfo == null) {
            return Collections.emptySet();
        }
        Map<String, ReleaseInformation> artifactInfo = groupInfo.get(artifactId);
        if (artifactInfo == null) {
            return Collections.emptySet();
        }
        return artifactInfo.keySet();
    }

    public void dumpArtifacts() {
        this.dumpArtifacts(LogLevel.INFO);
    }

    public void dumpArtifacts(LogLevel logLevel) {
        this.dumpArtifacts(log, logLevel);
    }

    public void dumpArtifacts(Logger log, LogLevel logLevel) {
        block7: for (ReleaseInformation info : this.getAllInfos()) {
            String s = info.toString();
            switch (logLevel) {
                case DEBUG: {
                    log.debug(s);
                    continue block7;
                }
                case ERROR: {
                    log.error(s);
                    continue block7;
                }
                case INFO: {
                    log.info(s);
                    continue block7;
                }
                case TRACE: {
                    log.trace(s);
                    continue block7;
                }
                case WARN: {
                    log.warn(s);
                    continue block7;
                }
            }
            log.info(s);
        }
    }

    public void dumpArtifacts(Writer writer) throws IOException {
        for (ReleaseInformation info : this.getAllInfos()) {
            writer.append(info.toString());
            writer.append("\n");
        }
    }
}

