/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.util;

import rs.baselib.util.DistanceCalculation;

public class HammingDistance
implements DistanceCalculation {
    public static final DistanceCalculation INSTANCE = new HammingDistance();

    @Override
    public int getDistance(String s1, String s2) {
        if (s1.length() != s2.length()) {
            return -1;
        }
        int counter = 0;
        for (int i = 0; i < s1.length(); ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            ++counter;
        }
        return counter;
    }

    public int minDistance(String[] numbers) {
        int minDistance = Integer.MAX_VALUE;
        if (this.checkConstraints(numbers).booleanValue()) {
            for (int i = 1; i < numbers.length; ++i) {
                int counter = 0;
                for (int j = 1; j <= numbers[i].length(); ++j) {
                    if (numbers[i - 1].charAt(j - 1) == numbers[i].charAt(j - 1)) continue;
                    ++counter;
                }
                if (counter == 0) {
                    return counter;
                }
                if (counter >= minDistance) continue;
                minDistance = counter;
            }
        } else {
            return -1;
        }
        return minDistance;
    }

    private Boolean checkConstraints(String[] numbers) {
        if (numbers.length > 1 && numbers.length <= 50) {
            int prevLength = -1;
            for (int i = 0; i < numbers.length; ++i) {
                if (numbers[i].length() > 0 && numbers[i].length() <= 50) {
                    if (prevLength == -1) {
                        prevLength = numbers[i].length();
                    } else if (prevLength != numbers[i].length()) {
                        return false;
                    }
                    for (int j = 0; j < numbers[i].length(); ++j) {
                        if (numbers[i].charAt(j) == '0' || numbers[i].charAt(j) == '1') continue;
                        return false;
                    }
                    continue;
                }
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

