/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.util;

import org.slf4j.LoggerFactory;
import rs.baselib.util.Environment;

public class EnvironmentRuntime {
    private static Environment runtime = EnvironmentRuntime.detectRuntime();

    public static Environment getRuntime() {
        return runtime;
    }

    public static void setRuntime(Environment newRuntime) {
        runtime = newRuntime;
    }

    public static Environment detectRuntime() {
        String envName = null;
        try {
            envName = System.getenv("RUNTIME_ENVIRONMENT");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (envName == null) {
            try {
                envName = System.getProperty("runtime.environment");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (envName == null) {
            envName = Environment.TEST.name();
        }
        try {
            return Environment.valueOf(envName);
        }
        catch (SecurityException e) {
            LoggerFactory.getLogger(EnvironmentRuntime.class).error("No such environment type: " + envName + " (Using " + Environment.TEST + " now)");
            return Environment.TEST;
        }
    }
}

