/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.util;

import rs.baselib.util.DistanceCalculation;

public class DamerauLevenshteinDistance
implements DistanceCalculation {
    public static final DistanceCalculation INSTANCE = new DamerauLevenshteinDistance();

    @Override
    public int getDistance(String s1, String s2) {
        int[][] matrix = this.getMatrix(s1, s2);
        return matrix[s1.length()][s2.length()];
    }

    public int[][] getMatrix(String s1, String s2) {
        int i;
        int cost = -1;
        int[][] matrix = new int[s1.length() + 1][s2.length() + 1];
        for (i = 0; i <= s1.length(); ++i) {
            matrix[i][0] = i;
        }
        for (i = 0; i <= s2.length(); ++i) {
            matrix[0][i] = i;
        }
        for (i = 1; i <= s1.length(); ++i) {
            for (int j = 1; j <= s2.length(); ++j) {
                cost = s1.charAt(i - 1) == s2.charAt(j - 1) ? 0 : 1;
                int del = matrix[i - 1][j] + 1;
                int ins = matrix[i][j - 1] + 1;
                int sub = matrix[i - 1][j - 1] + cost;
                matrix[i][j] = this.minimum(del, ins, sub);
                if (i <= 1 || j <= 1 || s1.charAt(i - 1) != s2.charAt(j - 2) || s1.charAt(i - 2) != s2.charAt(j - 1)) continue;
                matrix[i][j] = this.minimum(matrix[i][j], matrix[i - 2][j - 2] + cost);
            }
        }
        return matrix;
    }

    private int minimum(int d, int i, int s) {
        int m = Integer.MAX_VALUE;
        if (d < m) {
            m = d;
        }
        if (i < m) {
            m = i;
        }
        if (s < m) {
            m = s;
        }
        return m;
    }

    private int minimum(int d, int t) {
        int m = Integer.MAX_VALUE;
        if (d < m) {
            m = d;
        }
        if (t < m) {
            m = t;
        }
        return m;
    }
}

