/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.util;

import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import rs.baselib.lang.LangUtils;

public class CronSchedule
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NEVER_MARKER = "NEVER";
    private static final AbstractTimeValue[] NEVER_VALUES = new AbstractTimeValue[]{new NeverValue()};
    protected static int[] TYPES = new int[]{12, 11, 5, 2, 7};
    public static final CronSchedule NEVER = new CronSchedule("NEVER");
    private AbstractTimeValue[][] timeValues = new AbstractTimeValue[TYPES.length][];

    public CronSchedule() {
        this("*", "*", "*", "*", "*");
    }

    public CronSchedule(String schedule) {
        this.set(schedule);
    }

    public CronSchedule(String min, String hour, String dom, String mon, String dow) {
        this.set(12, min);
        this.set(11, hour);
        this.set(5, dom);
        this.set(2, mon);
        this.set(7, dow);
    }

    public String set(String schedule) {
        String[] parts = schedule.split(" ", TYPES.length + 1);
        if (NEVER_MARKER.equalsIgnoreCase(parts[0])) {
            for (int i = 0; i < TYPES.length; ++i) {
                this.set(CronSchedule.getType(i), NEVER_VALUES);
            }
            return parts.length > 1 ? parts[1] : null;
        }
        if (parts.length < TYPES.length) {
            throw new IllegalArgumentException("Invalid cron format: " + schedule);
        }
        for (int i = 0; i < TYPES.length; ++i) {
            this.set(CronSchedule.getType(i), parts[i]);
        }
        return parts.length > TYPES.length ? parts[TYPES.length] : null;
    }

    public void set(int type, String values) {
        String[] parts = values.split(",");
        AbstractTimeValue[] result = new AbstractTimeValue[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            result[i] = parts[i].indexOf("/") > 0 ? new TimeSteps(parts[i]) : (parts[i].indexOf("-") > 0 ? new TimeRange(parts[i]) : (parts[i].equals("*") ? new TimeAll() : new SingleTimeValue(parts[i])));
        }
        this.set(type, result);
    }

    protected void set(int type, AbstractTimeValue[] values) {
        this.timeValues[CronSchedule.getIndex((int)type)] = values;
    }

    protected AbstractTimeValue[] getValues(int type) {
        return this.timeValues[CronSchedule.getIndex(type)];
    }

    public String get(int type) {
        AbstractTimeValue[] values = this.getValues(type);
        StringBuilder rc = new StringBuilder(values.length);
        for (int i = 0; i < values.length; ++i) {
            rc.append(",");
            rc.append(values[i].toString());
        }
        return rc.substring(1);
    }

    public String getCronString() {
        StringBuilder rc = new StringBuilder();
        for (int i = 0; i < TYPES.length; ++i) {
            rc.append(" ");
            rc.append(this.get(CronSchedule.getType(i)));
        }
        String s = rc.toString().trim();
        if (s.startsWith(NEVER_MARKER)) {
            return NEVER_MARKER;
        }
        return s;
    }

    public String toString() {
        return this.getCronString();
    }

    public boolean matches(long timeStamp) {
        return this.matches(this.getCalendar(timeStamp));
    }

    public boolean matches(Calendar cal) {
        return this.isMinute(cal) && cal.get(13) == 0;
    }

    public boolean isMinute(long timeStamp) {
        return this.isMinute(this.getCalendar(timeStamp));
    }

    public boolean isMinute(Calendar cal) {
        return this.matches(12, cal) && this.isHour(cal);
    }

    public boolean isHour(long timestamp) {
        return this.isHour(this.getCalendar(timestamp));
    }

    public boolean isHour(Calendar cal) {
        return this.matches(11, cal) && this.isDay(cal);
    }

    public boolean isDay(long timestamp) {
        return this.isDay(this.getCalendar(timestamp));
    }

    public boolean isDay(Calendar cal) {
        return this.matches(7, cal) && this.matches(5, cal) && this.matches(2, cal);
    }

    protected boolean matches(int type, Calendar calendar) {
        AbstractTimeValue[] defs = this.timeValues[CronSchedule.getIndex(type)];
        int value = calendar.get(type);
        for (int i = 0; i < defs.length; ++i) {
            if (!defs[i].matches(value)) continue;
            return true;
        }
        return false;
    }

    protected Calendar getCalendar(long timeStamp) {
        GregorianCalendar rc = new GregorianCalendar();
        rc.setTimeInMillis(timeStamp);
        return rc;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    protected static int getType(int index) {
        return TYPES[index];
    }

    protected static int getIndex(int type) {
        for (int i = 0; i < TYPES.length; ++i) {
            if (TYPES[i] != type) continue;
            return i;
        }
        throw new IllegalArgumentException("No such time type: " + type);
    }

    public static abstract class AbstractTimeValue
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public abstract boolean matches(int var1);
    }

    public static class TimeSteps
    extends AbstractTimeValue {
        private static final long serialVersionUID = 1L;
        private AbstractTimeValue range;
        private int steps;

        public TimeSteps(AbstractTimeValue range, int steps) {
            this.setRange(range);
            this.setSteps(steps);
        }

        public TimeSteps(String def) {
            int divPos = def.indexOf("/");
            String r = def.substring(0, divPos);
            if (r.equals("*")) {
                this.setRange(new TimeAll());
            } else if (r.indexOf("-") > 0) {
                this.setRange(new TimeRange(r));
            } else if (LangUtils.getInt(r, -1) >= 0) {
                this.setRange(new SingleTimeValue(r));
            } else {
                throw new IllegalArgumentException("Invalid range: " + def);
            }
            this.setSteps(Integer.parseInt(def.substring(divPos + 1)));
        }

        @Override
        public boolean matches(int timeValue) {
            AbstractTimeValue range = this.getRange();
            boolean rc = false;
            if (range instanceof SingleTimeValue) {
                return timeValue % this.getSteps() == ((SingleTimeValue)range).getValue();
            }
            rc = range.matches(timeValue);
            if (rc) {
                rc = timeValue % this.getSteps() == 0;
            }
            return rc;
        }

        public AbstractTimeValue getRange() {
            return this.range;
        }

        public void setRange(AbstractTimeValue range) {
            this.range = range;
        }

        public int getSteps() {
            return this.steps;
        }

        public void setSteps(int steps) {
            this.steps = steps;
        }

        public String toString() {
            return this.getRange() + "/" + this.getSteps();
        }
    }

    public static class TimeRange
    extends AbstractTimeValue {
        private static final long serialVersionUID = 1L;
        private int startValue;
        private int endValue;

        public TimeRange(int startValue, int endValue) {
            this.setStartValue(startValue);
            this.setEndValue(endValue);
        }

        public TimeRange(String range) {
            int dashPos = range.indexOf("-");
            this.setStartValue(Integer.parseInt(range.substring(0, dashPos)));
            this.setEndValue(Integer.parseInt(range.substring(dashPos + 1)));
        }

        public int getEndValue() {
            return this.endValue;
        }

        public void setEndValue(int endValue) {
            this.endValue = endValue;
        }

        public int getStartValue() {
            return this.startValue;
        }

        public void setStartValue(int startValue) {
            this.startValue = startValue;
        }

        @Override
        public boolean matches(int timeValue) {
            return this.getStartValue() <= timeValue && timeValue <= this.getEndValue();
        }

        public String toString() {
            return this.getStartValue() + "-" + this.getEndValue();
        }
    }

    public static class TimeAll
    extends AbstractTimeValue {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean matches(int timeValue) {
            return true;
        }

        public String toString() {
            return "*";
        }
    }

    public static class SingleTimeValue
    extends AbstractTimeValue {
        private static final long serialVersionUID = 1L;
        private int value;

        public SingleTimeValue(int value) {
            this.setValue(value);
        }

        public SingleTimeValue(String value) {
            this.setValue(Integer.parseInt(value));
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        @Override
        public boolean matches(int timeValue) {
            return timeValue == this.getValue();
        }

        public String toString() {
            return "" + this.getValue();
        }
    }

    public static class NeverValue
    extends AbstractTimeValue {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean matches(int timeValue) {
            return false;
        }

        public String toString() {
            return CronSchedule.NEVER_MARKER;
        }
    }
}

