/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.util;

import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.baselib.bean.NamedObject;
import rs.baselib.util.IDisplayProvider;
import rs.baselib.util.IDisplayable;
import rs.baselib.util.ILocaleDisplayProvider;
import rs.baselib.util.IterableImpl;
import rs.baselib.util.RsDate;
import rs.baselib.util.RsDay;
import rs.baselib.util.RsMonth;
import rs.baselib.util.RsYear;

public class CommonUtils {
    private static Pattern ENV_VAR_PATTERN = Pattern.compile("\\$ENV\\{([^\\}]+)\\}");
    private static Pattern RUNTIME_VAR_PATTERN = Pattern.compile("\\$RUNTIME\\{([^\\}]+)\\}");
    public static int DEFAULT_CONNECT_TIMEOUT = 10000;
    public static int DEFAULT_READ_TIMEOUT = 20000;
    private static int connectTimeout = DEFAULT_CONNECT_TIMEOUT;
    private static int readTimeout = DEFAULT_READ_TIMEOUT;
    private static String OS = System.getProperty("os.name").toLowerCase();

    public static DateFormat DATE_FORMATTER() {
        return DateFormat.getDateInstance(3, Locale.getDefault());
    }

    public static DateFormat DATE_TIME_FORMATTER() {
        return DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
    }

    public static NumberFormat SIMPLE_NUMBER_FORMATTER() {
        return NumberFormat.getNumberInstance(Locale.getDefault());
    }

    public static NumberFormat SIMPLE_INT_FORMATTER() {
        return NumberFormat.getIntegerInstance(Locale.getDefault());
    }

    public static String toString(String o) {
        if (o == null) {
            return "";
        }
        return o;
    }

    public static String toString(float amount) {
        return CommonUtils.SIMPLE_NUMBER_FORMATTER().format(amount);
    }

    public static String toString(RsDate date) {
        if (date == null || date.getTimeInMillis() == 0L) {
            return "";
        }
        return CommonUtils.DATE_TIME_FORMATTER().format(date.getTime());
    }

    public static String toString(RsDay day) {
        if (day == null || day.getTimeInMillis() == (long)(-TimeZone.getDefault().getOffset(day.getTimeInMillis()))) {
            return "";
        }
        return CommonUtils.DATE_FORMATTER().format(day.getTime());
    }

    public static String toString(RsYear year) {
        if (year == null || year.get(1) == 1) {
            return "";
        }
        return year.getKey();
    }

    public static String toString(RsMonth month) {
        if (month == null || month.getTimeInMillis() == 0L) {
            return "";
        }
        return CommonUtils.DATE_FORMATTER().format(month.getBegin().getTime());
    }

    public static String toString(byte[] b) {
        if (b == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        if (b != null) {
            for (int i = 0; i < b.length; ++i) {
                buf.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
            }
        }
        return buf.toString();
    }

    public static String toString(Object[] o) {
        if (o == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (Object object : o) {
            if (buf.length() > 1) {
                buf.append(",");
            }
            if (object == null) {
                buf.append("null");
                continue;
            }
            buf.append(object.toString());
        }
        buf.append("]");
        return buf.toString();
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o2 != null) {
            if (o1 instanceof BigDecimal && o2 instanceof BigDecimal) {
                return ((BigDecimal)o1).compareTo((BigDecimal)o2) == 0;
            }
            return o1.equals(o2);
        }
        return false;
    }

    public static boolean isEmpty(String s) {
        return CommonUtils.isEmpty(s, true);
    }

    public static boolean isEmpty(String s, boolean trim) {
        if (s == null) {
            return true;
        }
        if (trim) {
            s = s.trim();
        }
        return s.length() == 0;
    }

    public static String[] getOptions(Class<? extends Enum<?>> clazz) {
        return CommonUtils.getOptions(clazz, Locale.getDefault());
    }

    public static String[] getOptions(Class<? extends Enum<?>> clazz, Locale locale) {
        Enum<?>[] enums = clazz.getEnumConstants();
        if (enums != null) {
            String[] rc = new String[enums.length];
            for (int i = 0; i < enums.length; ++i) {
                rc[i] = CommonUtils.getDisplay(enums[i], locale);
            }
            return rc;
        }
        return new String[0];
    }

    public static List<Enum<?>> getOptionList(Class<? extends Enum<?>> clazz) {
        Enum<?>[] arr = clazz.getEnumConstants();
        ArrayList rc = new ArrayList();
        if (arr != null) {
            for (Enum<?> s : arr) {
                rc.add(s);
            }
        }
        return rc;
    }

    public static String getDisplay(Enum<?> e) {
        return CommonUtils.getDisplay(e, Locale.getDefault());
    }

    public static String getDisplay(Enum<?> e, Locale locale) {
        if (e instanceof ILocaleDisplayProvider) {
            return ((ILocaleDisplayProvider)((Object)e)).getDisplay(locale);
        }
        return e.name();
    }

    public static Enum<?> getEnum(Class<? extends Enum<?>> clazz, String display) {
        return CommonUtils.getEnum(clazz, display, Locale.getDefault());
    }

    public static Enum<?> getEnum(Class<? extends Enum<?>> clazz, String display, Locale locale) {
        Enum<?>[] arr = clazz.getEnumConstants();
        if (arr != null) {
            for (Enum<?> e : arr) {
                if (!display.equals(CommonUtils.getDisplay(e, locale))) continue;
                return e;
            }
        }
        return null;
    }

    public static boolean isCompatibleVersion(String minVersion, String maxVersion, String version) {
        if (version == null) {
            return true;
        }
        if (minVersion != null && CommonUtils.compareVersion(minVersion, version) > 0) {
            return false;
        }
        return maxVersion == null || CommonUtils.compareVersion(maxVersion, version) >= 0;
    }

    public static int compareVersion(String v1, String v2) {
        String[] v1Parts = ArrayUtils.EMPTY_STRING_ARRAY;
        String[] v2Parts = ArrayUtils.EMPTY_STRING_ARRAY;
        if (v1 != null) {
            v1Parts = v1.split("\\.");
        }
        if (v2 != null) {
            v2Parts = v2.split("\\.");
        }
        return CommonUtils.compareVersion(v1Parts, v2Parts);
    }

    public static int compareVersion(String[] v1, String[] v2) {
        int maxCount = Math.max(v1.length, v2.length);
        for (int i = 0; i < maxCount; ++i) {
            try {
                long l1 = 0L;
                if (i < v1.length) {
                    l1 = Long.parseLong(v1[i]);
                }
                long l2 = 0L;
                if (i < v2.length) {
                    l2 = Long.parseLong(v2[i]);
                }
                if (l1 < l2) {
                    return -1;
                }
                if (l1 <= l2) continue;
                return 1;
            }
            catch (NumberFormatException e) {
                int rc = v1[i].compareTo(v2[i]);
                if (rc == 0) continue;
                return rc;
            }
        }
        if (v1.length > v2.length) {
            return 1;
        }
        if (v1.length < v2.length) {
            return -1;
        }
        return 0;
    }

    public static String join(String separator, Collection<?> parts) {
        return CommonUtils.join(separator, parts, 0, parts.size() + 1);
    }

    public static String join(String separator, String[] parts) {
        return CommonUtils.join(separator, parts, 0, parts.length + 1);
    }

    public static String join(String separator, Object[] parts) {
        return CommonUtils.join(separator, parts, 0, parts.length + 1);
    }

    public static String join(String separator, String[] parts, int startIndex) {
        return CommonUtils.join(separator, parts, startIndex, parts.length + 1);
    }

    public static String join(String separator, Collection<?> parts, int startIndex) {
        return CommonUtils.join(separator, parts, startIndex, parts.size() + 1);
    }

    public static String join(String separator, Object[] parts, int startIndex) {
        return CommonUtils.join(separator, parts, startIndex, parts.length + 1);
    }

    public static String join(String separator, String[] parts, int startIndex, int endIndex) {
        StringBuilder s = new StringBuilder();
        for (int i = startIndex; i < parts.length && i <= endIndex; ++i) {
            if (i != startIndex) {
                s.append(separator);
            }
            s.append(parts[i]);
        }
        return s.toString();
    }

    public static String join(String separator, Object[] parts, int startIndex, int endIndex) {
        StringBuilder s = new StringBuilder();
        for (int i = startIndex; i < parts.length && i <= endIndex; ++i) {
            if (i != startIndex) {
                s.append(separator);
            }
            s.append(parts[i] != null ? parts[i].toString() : "");
        }
        return s.toString();
    }

    public static String join(String separator, Collection<?> parts, int startIndex, int endIndex) {
        return CommonUtils.join(separator, parts.toArray(new Object[parts.size()]), startIndex, endIndex);
    }

    public static String debugObject(Object o) {
        StringBuilder b = new StringBuilder();
        CommonUtils.debugObject(b, o);
        return b.toString();
    }

    public static void debugObject(StringBuffer s, Object o) {
        StringBuilder b = new StringBuilder();
        CommonUtils.debugObject(b, o);
        s.append((CharSequence)b);
    }

    public static void debugObject(StringBuilder s, Object o) {
        if (o == null) {
            s.append("NULL");
        } else if (o instanceof Collection) {
            s.append(o.getClass().getSimpleName());
            s.append('[');
            boolean isFirst = true;
            for (Object o2 : (Collection)o) {
                if (!isFirst) {
                    s.append(',');
                }
                isFirst = false;
                CommonUtils.debugObject(s, o2);
            }
            s.append(']');
        } else if (o instanceof Map) {
            s.append(o.getClass().getSimpleName());
            s.append('[');
            boolean isFirst = true;
            for (Object key : ((Map)o).keySet()) {
                if (!isFirst) {
                    s.append(',');
                }
                isFirst = false;
                s.append(key);
                s.append('=');
                CommonUtils.debugObject(s, ((Map)o).get(key));
            }
            s.append(']');
        } else if (o.getClass().isArray()) {
            s.append('[');
            boolean isFirst = true;
            for (Object o2 : (Object[])o) {
                if (!isFirst) {
                    s.append(',');
                }
                isFirst = false;
                CommonUtils.debugObject(s, o2);
            }
            s.append(']');
        } else {
            s.append(o.getClass().getName());
            s.append('{');
            s.append(o.toString());
            s.append('}');
        }
    }

    public static long getUnixTimestamp() {
        return CommonUtils.getUnixTimestamp(System.currentTimeMillis());
    }

    public static long getUnixTimestamp(Date date) {
        return CommonUtils.getUnixTimestamp(date.getTime());
    }

    public static long getUnixTimestamp(RsDate date) {
        return CommonUtils.getUnixTimestamp(date.getTimeInMillis());
    }

    public static long getUnixTimestamp(long time) {
        return time / 1000L;
    }

    public static <T> Iterable<T> iterable(Iterator<T> iterator) {
        return new IterableImpl<T>(iterator);
    }

    public static List<String> getStackTrace(int ignoreLines) {
        StackTraceElement[] lines;
        ArrayList<String> rc = new ArrayList<String>();
        ++ignoreLines;
        RuntimeException e = new RuntimeException();
        for (StackTraceElement line : lines = e.getStackTrace()) {
            if (ignoreLines > 0) {
                --ignoreLines;
                continue;
            }
            StringBuilder s = new StringBuilder();
            s.append("      at ");
            s.append(line.getClassName());
            s.append(".");
            s.append(line.getMethodName());
            s.append("(");
            if (line.getFileName() != null) {
                s.append(line.getFileName());
                s.append(":");
                s.append(line.getLineNumber());
            } else {
                s.append("unknown source");
            }
            s.append(")");
            rc.add(s.toString());
        }
        return rc;
    }

    public static void stdoutStackTrace() {
        CommonUtils.printStackTrace(System.out, 1);
    }

    public static void stderrStackTrace() {
        CommonUtils.printStackTrace(System.err, 1);
    }

    public static void printStackTrace(PrintStream out, int ignoreLines) {
        for (String s : CommonUtils.getStackTrace(ignoreLines + 1)) {
            out.println(s);
        }
    }

    public static void errorStackTrace(Logger log) {
        for (String s : CommonUtils.getStackTrace(2)) {
            log.debug(s);
        }
    }

    public static void infoStackTrace(Logger log) {
        for (String s : CommonUtils.getStackTrace(2)) {
            log.info(s);
        }
    }

    public static void debugStackTrace(Logger log) {
        for (String s : CommonUtils.getStackTrace(2)) {
            log.debug(s);
        }
    }

    public static void traceStackTrace(Logger log) {
        for (String s : CommonUtils.getStackTrace(2)) {
            log.trace(s);
        }
    }

    public static Properties loadProperties(File file) throws IOException {
        Properties props = new Properties();
        CommonUtils.loadProperties(props, file);
        return props;
    }

    public static Properties loadProperties(String file) throws IOException {
        return CommonUtils.loadProperties(new File(file));
    }

    public static void loadProperties(Properties props, File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            props.load(in);
        }
    }

    public static void loadProperties(Properties props, String file) throws IOException {
        CommonUtils.loadProperties(props, new File(file));
    }

    public static void storeProperties(Properties props, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            props.store(out, null);
        }
    }

    public static void storeProperties(Properties props, String file) throws IOException {
        CommonUtils.storeProperties(props, new File(file));
    }

    public static int getConnectTimeout() {
        return connectTimeout;
    }

    public static void setConnectTimeout(int connectTimeout) {
        CommonUtils.connectTimeout = connectTimeout;
    }

    public static int getReadTimeout() {
        return readTimeout;
    }

    public static void setReadTimeout(int readTimeout) {
        CommonUtils.readTimeout = readTimeout;
    }

    public static String loadContent(URL url) throws IOException {
        return CommonUtils.loadContent(url, null);
    }

    public static String loadContent(URL url, Charset charset) throws IOException {
        return CommonUtils.loadContent(url.openConnection(), charset);
    }

    public static String loadContent(URLConnection con, Charset charset) throws IOException {
        con.setConnectTimeout(CommonUtils.getConnectTimeout());
        con.setReadTimeout(CommonUtils.getReadTimeout());
        return CommonUtils.loadContent(con.getInputStream(), charset);
    }

    public static String loadContent(String name) throws IOException {
        return CommonUtils.loadContent(name, null);
    }

    public static String loadContent(String name, Charset charset) throws IOException {
        return CommonUtils.loadContent(new File(name), charset);
    }

    public static String loadContent(File f) throws IOException {
        return CommonUtils.loadContent(f, null);
    }

    public static String loadContent(File f, Charset charset) throws IOException {
        return CommonUtils.loadContent(new FileInputStream(f), charset);
    }

    public static String loadContent(InputStream in) throws IOException {
        return CommonUtils.loadContent(in, null);
    }

    public static String loadContent(InputStream in, Charset charset) throws IOException {
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        return CommonUtils.loadContent(new InputStreamReader(in, charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadContent(Reader reader) throws IOException {
        BufferedReader r = null;
        try {
            StringBuilder rc = new StringBuilder(1000);
            r = new BufferedReader(reader);
            String line = null;
            while ((line = r.readLine()) != null) {
                rc.append(line);
                rc.append('\n');
            }
            String string = rc.toString();
            return string;
        }
        finally {
            if (r != null) {
                r.close();
            } else {
                reader.close();
            }
        }
    }

    public static void writeContent(String name, String content) throws IOException {
        CommonUtils.writeContent(name, content, null);
    }

    public static void writeContent(String name, String content, Charset charset) throws IOException {
        CommonUtils.writeContent(new File(name), content, charset);
    }

    public static void writeContent(File f, String content) throws IOException {
        CommonUtils.writeContent(f, content, null);
    }

    public static void writeContent(File f, String content, Charset charset) throws IOException {
        CommonUtils.writeContent(new FileOutputStream(f), content, charset);
    }

    public static void writeContent(OutputStream out, String content) throws IOException {
        CommonUtils.writeContent(out, content, null);
    }

    public static void writeContent(OutputStream out, String content, Charset charset) throws IOException {
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        CommonUtils.writeContent(new OutputStreamWriter(out, charset), content);
    }

    public static void writeContent(Writer writer, String content) throws IOException {
        try {
            writer.write(content);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return OS.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0 || OS.indexOf("sunos") >= 0;
    }

    public static boolean isSolaris() {
        return OS.indexOf("sunos") >= 0;
    }

    public static boolean isEmail(String s) {
        return !CommonUtils.isEmpty(s) && EmailValidator.getInstance().isValid(s.trim());
    }

    public static String getOS() {
        return OS;
    }

    public static String getDisplay(Object o) {
        return CommonUtils.getDisplay(o, Locale.getDefault());
    }

    public static String getDisplay(Object o, Locale locale) {
        if (o == null) {
            return "";
        }
        String rc = o.toString();
        if (o instanceof IDisplayable) {
            rc = ((IDisplayable)o).toString(locale);
        } else if (o instanceof IDisplayProvider) {
            rc = ((IDisplayProvider)o).getDisplay();
        } else if (o instanceof NamedObject) {
            rc = ((NamedObject)o).getName();
        }
        return rc;
    }

    public static URL setAnchor(URL url, String anchor) {
        try {
            String[] paths = url.getPath().split("#", 2);
            if (CommonUtils.isEmpty(anchor)) {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), paths[0]);
            }
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), paths[0] + "#" + anchor);
        }
        catch (MalformedURLException e) {
            LoggerFactory.getLogger(CommonUtils.class).error("Cannot append anchor", (Throwable)e);
            return url;
        }
    }

    public static String replaceEnvVariables(String s) {
        if (CommonUtils.isEmpty(s)) {
            return s;
        }
        int replaces = 0;
        do {
            replaces = 0;
            StringBuilder replaced = new StringBuilder();
            Matcher m = ENV_VAR_PATTERN.matcher(s);
            int lastEnd = 0;
            while (m.find()) {
                String name = m.group(1);
                int start = m.start();
                if (start > lastEnd) {
                    replaced.append(s.substring(lastEnd, start));
                }
                replaced.append(System.getenv(name));
                lastEnd = m.end();
                ++replaces;
            }
            if (lastEnd < s.length()) {
                replaced.append(s.substring(lastEnd, s.length()));
            }
            s = replaced.toString();
        } while (replaces > 0);
        return s;
    }

    public static String replaceRuntimeVariables(String s) {
        if (CommonUtils.isEmpty(s)) {
            return s;
        }
        int replaces = 0;
        do {
            replaces = 0;
            StringBuilder replaced = new StringBuilder();
            Matcher m = RUNTIME_VAR_PATTERN.matcher(s);
            int lastEnd = 0;
            while (m.find()) {
                String name = m.group(1);
                int start = m.start();
                if (start > lastEnd) {
                    replaced.append(s.substring(lastEnd, start));
                }
                replaced.append(System.getProperty(name));
                lastEnd = m.end();
                ++replaces;
            }
            if (lastEnd < s.length()) {
                replaced.append(s.substring(lastEnd, s.length()));
            }
            s = replaced.toString();
        } while (replaces > 0);
        return s;
    }

    public static String replaceVariables(String s) {
        if (CommonUtils.isEmpty(s)) {
            return s;
        }
        String oldS = s;
        do {
            oldS = s;
            s = CommonUtils.replaceEnvVariables(s);
        } while (!(s = CommonUtils.replaceRuntimeVariables(s)).equals(oldS));
        return s;
    }

    public static String setMarkers(String template, String prefix, Object valueObject) {
        if (valueObject == null) {
            return template;
        }
        if (template == null) {
            return null;
        }
        HashMap<String, Object> oValues = null;
        if (valueObject instanceof Map) {
            oValues = (HashMap<String, Object>)valueObject;
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (PropertyDescriptor desc : PropertyUtils.getPropertyDescriptors((Object)valueObject)) {
                try {
                    Method m = desc.getReadMethod();
                    if (m == null) continue;
                    Object value = m.invoke(valueObject, new Object[0]);
                    map.put(desc.getName(), value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    map.put(desc.getName(), null);
                }
            }
            oValues = map;
        }
        for (Map.Entry entry : oValues.entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey().toString();
            String marker = "\\{@" + prefix + ":" + key + "\\}";
            if (value != null) {
                template = template.replaceAll(marker, value.toString());
                continue;
            }
            template = template.replaceAll(marker, "");
        }
        return template;
    }
}

