/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import rs.baselib.lang.LangUtils;
import rs.baselib.sql.IDataSourceProvider;
import rs.baselib.sql.IHibernateDialectProvider;
import rs.baselib.sql.IJdbcConnectionProvider2;
import rs.baselib.util.CommonUtils;
import rs.baselib.util.IDisplayProvider;

public abstract class AbstractJdbcConnectionProvider
implements IJdbcConnectionProvider2,
IDisplayProvider,
IDataSourceProvider,
IHibernateDialectProvider {
    private String dbDriverClassName;
    private String urlTemplate;
    private String display;
    private String hibernateDialect;
    private String dataSource;
    private boolean hostEnabled = true;
    private String defaultHost = null;
    private boolean portEnabled = true;
    private String defaultPort = null;
    private boolean dbNameEnabled = true;
    private String defaultDbName = null;
    private boolean dbLoginEnabled = true;
    private String defaultDbLogin = null;
    private boolean dbPasswordEnabled = true;
    private String defaultDbPassword = null;
    private int maxAdditionalArgumentIndex = -1;
    private Map<Integer, String> additionalArgumentNames = new HashMap<Integer, String>();
    private Set<Integer> enabledAdditionalArguments = new HashSet<Integer>();
    private Map<Integer, String> defaultAdditionalArguments = new HashMap<Integer, String>();
    private Map<String, String> driverParameters = new HashMap<String, String>();

    public AbstractJdbcConnectionProvider(String display) {
        this(display, null, null);
    }

    public AbstractJdbcConnectionProvider(String display, String urlTemplate) {
        this(display, null, urlTemplate);
    }

    public AbstractJdbcConnectionProvider(String display, String dbDriverClassName, String urlTemplate) {
        this.display = display;
        this.dbDriverClassName = dbDriverClassName;
        this.urlTemplate = urlTemplate;
    }

    @Override
    public Connection getConnection(String host, String port, String dbName, String dbLogin, String dbPassword, String ... addOnArgs) throws SQLException {
        String driverName = this.getDbDriverClassName();
        if (driverName == null) {
            throw new SQLException("No JDBC driver specified");
        }
        try {
            LangUtils.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("JDBC driver \"" + driverName + "\" not found", e);
        }
        String url = null;
        try {
            url = this.getDriverUrl(host, port, dbName, dbLogin, dbPassword, addOnArgs);
        }
        catch (Throwable t) {
            throw new SQLException("Cannot construct driver URL: " + t.getLocalizedMessage(), t);
        }
        if (url == null) {
            throw new SQLException("Cannot construct driver URL");
        }
        return DriverManager.getConnection(url, dbLogin, dbPassword);
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    @Override
    public String getDbDriverClassName() {
        return this.dbDriverClassName;
    }

    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    @Override
    public String getDriverUrl(String host, String port, String dbName, String dbLogin, String dbPassword, String ... addOnArgs) {
        if (this.urlTemplate == null) {
            return null;
        }
        if (CommonUtils.isEmpty(port, true)) {
            port = this.getDefaultPort();
        }
        Object[] args = new Object[this.maxAdditionalArgumentIndex + 6];
        args[0] = this.getHost(host);
        args[1] = this.getPort(port);
        args[2] = this.getDbName(dbName);
        args[3] = this.getDbLogin(dbLogin);
        args[4] = this.getDbPassword(dbPassword);
        for (int i = 0; i <= this.maxAdditionalArgumentIndex; ++i) {
            args[i + 5] = this.getAdditionalArgument(i, i < addOnArgs.length ? addOnArgs[i] : null);
        }
        return MessageFormat.format(this.getUrlTemplate(), args) + this.getDriverParametersString();
    }

    @Override
    public String getDataSource() {
        return this.dataSource;
    }

    protected void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getHibernateDialect() {
        return this.hibernateDialect;
    }

    public void setHibernateDialect(String hibernateDialect) {
        this.hibernateDialect = hibernateDialect;
    }

    @Override
    public String getHost(String s) {
        if (!this.isHostEnabled() || CommonUtils.isEmpty(s)) {
            return this.getDefaultHost();
        }
        return s.trim();
    }

    @Override
    public boolean isHostEnabled() {
        return this.hostEnabled;
    }

    @Override
    public void setHostEnabled(boolean b) {
        this.hostEnabled = b;
    }

    @Override
    public void setHost(boolean enabled, String defaultValue) {
        this.setHostEnabled(enabled);
        this.setDefaultHost(defaultValue);
    }

    @Override
    public String getDefaultHost() {
        return this.defaultHost;
    }

    @Override
    public void setDefaultHost(String s) {
        this.defaultHost = s;
    }

    @Override
    public String getPort(String s) {
        if (!this.isPortEnabled() || CommonUtils.isEmpty(s)) {
            return this.getDefaultPort();
        }
        return s.trim();
    }

    @Override
    public boolean isPortEnabled() {
        return this.portEnabled;
    }

    @Override
    public void setPortEnabled(boolean b) {
        this.portEnabled = b;
    }

    @Override
    public void setPort(boolean enabled, String defaultValue) {
        this.setPortEnabled(enabled);
        this.setDefaultPort(defaultValue);
    }

    @Override
    public String getDefaultPort() {
        return this.defaultPort;
    }

    @Override
    public void setDefaultPort(String s) {
        this.defaultPort = s;
    }

    @Override
    public String getDbName(String s) {
        if (!this.isDbNameEnabled() || CommonUtils.isEmpty(s)) {
            return this.getDefaultDbName();
        }
        return s.trim();
    }

    @Override
    public boolean isDbNameEnabled() {
        return this.dbNameEnabled;
    }

    @Override
    public void setDbNameEnabled(boolean b) {
        this.dbNameEnabled = b;
    }

    @Override
    public void setDbName(boolean enabled, String defaultValue) {
        this.setDbNameEnabled(enabled);
        this.setDefaultDbName(defaultValue);
    }

    @Override
    public String getDefaultDbName() {
        return this.defaultDbName;
    }

    @Override
    public void setDefaultDbName(String s) {
        this.defaultDbName = s;
    }

    @Override
    public String getDbLogin(String s) {
        if (!this.isDbLoginEnabled() || CommonUtils.isEmpty(s)) {
            return this.getDefaultDbLogin();
        }
        return s.trim();
    }

    @Override
    public boolean isDbLoginEnabled() {
        return this.dbLoginEnabled;
    }

    @Override
    public void setDbLoginEnabled(boolean b) {
        this.dbLoginEnabled = b;
    }

    @Override
    public void setDbLogin(boolean enabled, String defaultValue) {
        this.setDbLoginEnabled(enabled);
        this.setDefaultDbLogin(defaultValue);
    }

    @Override
    public String getDefaultDbLogin() {
        return this.defaultDbLogin;
    }

    @Override
    public void setDefaultDbLogin(String s) {
        this.defaultDbLogin = s;
    }

    @Override
    public String getDbPassword(String s) {
        if (!this.isDbPasswordEnabled() || CommonUtils.isEmpty(s)) {
            return this.getDefaultDbPassword();
        }
        return s.trim();
    }

    @Override
    public boolean isDbPasswordEnabled() {
        return this.dbPasswordEnabled;
    }

    @Override
    public void setDbPasswordEnabled(boolean b) {
        this.dbPasswordEnabled = b;
    }

    @Override
    public void setDbPassword(boolean enabled, String defaultValue) {
        this.setDbPasswordEnabled(enabled);
        this.setDefaultDbPassword(defaultValue);
    }

    @Override
    public String getDefaultDbPassword() {
        return this.defaultDbPassword;
    }

    @Override
    public void setDefaultDbPassword(String s) {
        this.defaultDbPassword = s;
    }

    @Override
    public String getAdditionalArgument(int index, String s) {
        if (!this.isAdditionalArgumentEnabled(index) || CommonUtils.isEmpty(s)) {
            return this.getDefaultAdditionalArgument(index);
        }
        return s.trim();
    }

    @Override
    public boolean isAdditionalArgumentEnabled(int index) {
        return this.enabledAdditionalArguments.contains(index);
    }

    @Override
    public void setAdditionalArgumentEnabled(int index, boolean b) {
        if (b) {
            this.enabledAdditionalArguments.add(index);
        } else {
            this.enabledAdditionalArguments.remove(index);
        }
        if (index > this.maxAdditionalArgumentIndex) {
            this.maxAdditionalArgumentIndex = index;
        }
    }

    @Override
    public void setAdditionalArgument(int index, String name, boolean enabled, String defaultValue) {
        this.setAdditionalArgumentEnabled(index, enabled);
        this.setDefaultAdditionalArgument(index, defaultValue);
        this.setAdditionalArgumentName(index, name);
    }

    @Override
    public String getDefaultAdditionalArgument(int index) {
        return this.defaultAdditionalArguments.get(index);
    }

    @Override
    public void setDefaultAdditionalArgument(int index, String s) {
        this.defaultAdditionalArguments.put(index, s);
        if (index > this.maxAdditionalArgumentIndex) {
            this.maxAdditionalArgumentIndex = index;
        }
    }

    @Override
    public String getAdditionalArgumentName(int index) {
        return this.additionalArgumentNames.get(index);
    }

    @Override
    public void setAdditionalArgumentName(int index, String s) {
        this.additionalArgumentNames.put(index, s);
        if (index > this.maxAdditionalArgumentIndex) {
            this.maxAdditionalArgumentIndex = index;
        }
    }

    @Override
    public String[] getAdditionalArgumentNames() {
        String[] rc = new String[this.maxAdditionalArgumentIndex + 1];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = this.getAdditionalArgumentName(i);
        }
        return rc;
    }

    @Override
    public int getAdditionalArgumentCount() {
        return this.maxAdditionalArgumentIndex + 1;
    }

    @Override
    public int getDriverParameterCount() {
        return this.driverParameters.size();
    }

    @Override
    public void setDriverParameter(String name, String value) {
        if (value != null) {
            this.driverParameters.put(name, value);
        } else {
            this.driverParameters.remove(name);
        }
    }

    @Override
    public String getDriverParameter(String name) {
        return this.driverParameters.get(name);
    }

    @Override
    public String getDriverParametersString() {
        if (this.driverParameters.isEmpty()) {
            return "";
        }
        StringBuilder rc = new StringBuilder();
        for (Map.Entry<String, String> entry : this.driverParameters.entrySet()) {
            if (rc.length() == 0) {
                rc.append('?');
            } else {
                rc.append('&');
            }
            rc.append(entry.getKey());
            rc.append('=');
            rc.append(entry.getValue());
        }
        return rc.toString();
    }
}

