/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.prefs;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.baselib.prefs.AbstractPreferencesService;
import rs.baselib.prefs.IPreferences;
import rs.baselib.prefs.IPreferencesService;
import rs.baselib.prefs.Preferences;
import rs.baselib.util.CommonUtils;

public class PreferencesService
extends AbstractPreferencesService {
    private static final Logger log = LoggerFactory.getLogger(PreferencesService.class);
    public static final IPreferencesService INSTANCE = new PreferencesService();
    private File userHome = null;
    private File systemHome = null;
    private Map<String, File> userHomes = new HashMap<String, File>();
    private Map<String, File> systemHomes = new HashMap<String, File>();

    private PreferencesService() {
    }

    @Override
    protected IPreferences createRootNode() {
        return new Preferences(null, null);
    }

    @Override
    protected void loadUserPreferences(IPreferences node, String applicationName) throws BackingStoreException {
        File f = this.getUserPreferencesFile(applicationName);
        if (log.isDebugEnabled()) {
            log.debug("Loading user preferences: " + f.getAbsolutePath());
        }
        this.load(node, this.getInputStream(f));
    }

    @Override
    protected void loadSystemPreferences(IPreferences node, String applicationName) throws BackingStoreException {
        File f = this.getSystemPreferencesFile(applicationName);
        if (log.isDebugEnabled()) {
            log.debug("Loading system preferences: " + f.getAbsolutePath());
        }
        this.load(node, this.getInputStream(f));
    }

    @Override
    protected void flushUserPreferences(IPreferences node, String applicationName) throws BackingStoreException {
        this.save(node, this.getOutputStream(this.getUserPreferencesFile(applicationName)));
    }

    @Override
    protected void flushSystemPreferences(IPreferences node, String applicationName) throws BackingStoreException {
        this.save(node, this.getOutputStream(this.getSystemPreferencesFile(applicationName)));
    }

    protected InputStream getInputStream(File f) throws BackingStoreException {
        try {
            if (f.exists() && f.canRead()) {
                return new FileInputStream(f);
            }
            return new ByteArrayInputStream(new byte[0]);
        }
        catch (IOException e) {
            throw new BackingStoreException(e);
        }
    }

    protected OutputStream getOutputStream(File f) throws BackingStoreException {
        try {
            File parent;
            if (!(f.exists() || (parent = f.getParentFile()).exists() || parent.mkdirs())) {
                throw new BackingStoreException("Cannot create parent directory: " + f.getParent());
            }
            return new FileOutputStream(f);
        }
        catch (IOException e) {
            throw new BackingStoreException(e);
        }
    }

    protected void load(IPreferences node, InputStream in) throws BackingStoreException {
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            String s = null;
            while ((s = r.readLine()) != null) {
                String[] l;
                if (CommonUtils.isEmpty(s) || s.startsWith("#") || (l = s.split("=", 2)).length <= 1) continue;
                this.put(node, l[0].trim(), l[1].trim());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new BackingStoreException(e);
        }
        catch (IOException e) {
            throw new BackingStoreException(e);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void put(IPreferences node, String key, String value) {
        if (key.length() == 0) {
            return;
        }
        String[] l = key.split("\\/");
        if (l.length > 1) {
            node = node.node(CommonUtils.join("/", l, 0, l.length - 2));
        }
        node.put(l[l.length - 1], value);
    }

    protected void save(IPreferences node, OutputStream out) throws BackingStoreException {
        PrintWriter w = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        this.save(null, node, w);
        w.close();
    }

    protected void save(String prefix, IPreferences node, PrintWriter out) throws BackingStoreException {
        try {
            for (String k : node.keys()) {
                if (prefix != null) {
                    out.print(prefix + "/");
                }
                out.println(k + "=" + node.get(k, ""));
            }
            for (String n : node.childrenNames()) {
                String nodePrefix = prefix != null ? prefix + "/" + n : n;
                this.save(nodePrefix, node.node(n), out);
            }
        }
        catch (BackingStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
    }

    @Override
    public File getUserPreferencesHome(String applicationName) {
        File f;
        String env = System.getenv(applicationName.toUpperCase() + "_PREFERENCES_HOME");
        if (env != null && (f = new File(env)).exists() && f.isDirectory()) {
            return f;
        }
        return new File(this.getUserHome(), "." + applicationName);
    }

    protected File getUserHome() {
        if (this.userHome == null) {
            this.userHome = new File(System.getProperty("user.home"));
        }
        return this.userHome;
    }

    protected synchronized File getUserPreferencesFile(String applicationName) {
        File rc = this.userHomes.get(applicationName);
        if (rc == null) {
            String env = System.getenv(applicationName.toUpperCase() + "_PREFERENCES_FILE");
            if (!(env == null || (rc = new File(env)).exists() && rc.isFile())) {
                rc = null;
            }
            if (rc == null) {
                rc = new File(this.getUserPreferencesHome(applicationName), "user.prefs");
            }
            this.userHomes.put(applicationName, rc);
        }
        return rc;
    }

    @Override
    public File getSystemPreferencesHome(String applicationName) {
        File home = this.getSystemHome();
        File parentDir = new File(home, applicationName);
        if (!parentDir.exists() && !home.canWrite()) {
            log.info("Cannot write to " + home.getAbsolutePath() + " - using user home directory for system preferences");
            parentDir = this.getUserPreferencesHome(applicationName);
        } else if (parentDir.exists() && !parentDir.canWrite()) {
            log.info("Cannot write to " + parentDir.getAbsolutePath() + " - using user home directory for system preferences");
            parentDir = this.getUserPreferencesHome(applicationName);
        }
        return parentDir;
    }

    protected synchronized File getSystemPreferencesFile(String applicationName) {
        File rc = this.systemHomes.get(applicationName);
        if (rc == null) {
            File parentDir = this.getSystemPreferencesHome(applicationName);
            rc = new File(parentDir, "system.prefs");
            if (rc.exists() && !rc.canWrite()) {
                log.info("Cannot write to " + rc.getAbsolutePath() + " - using user home directory for system preferences");
                parentDir = this.getUserPreferencesHome(applicationName);
            }
            rc = new File(parentDir, "system.prefs");
            this.systemHomes.put(applicationName, rc);
        }
        return rc;
    }

    protected File getSystemHome() {
        if (this.systemHome == null) {
            if (CommonUtils.isWindows()) {
                this.systemHome = new File("C:/Documents and Settings/All Users");
            } else if (CommonUtils.isMac()) {
                this.systemHome = new File("/var");
            } else if (CommonUtils.isUnix()) {
                this.systemHome = new File("/var");
            }
            if (this.systemHome == null) {
                log.info("Cannot determine OS type from \"" + CommonUtils.getOS() + "\" - using user home directory for system preferences");
                this.systemHome = this.getUserHome();
            }
        }
        return this.systemHome;
    }
}

