/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.prefs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.prefs.BackingStoreException;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;
import rs.baselib.lang.LangUtils;
import rs.baselib.prefs.IPreferences;
import rs.baselib.prefs.IPreferencesService;

public abstract class AbstractPreferencesService
implements IPreferencesService {
    private static final Pattern PATTERN = Pattern.compile("[-A-Za-z._@]+");
    private static final String USER_NODE_NAME = "@USER";
    private static final String SYSTEM_NODE_NAME = "@SYSTEM";
    private static final long FLUSH_DELAY = 500L;
    private IPreferences rootNode;
    private Object SYNCH_OBJECT = new Object();
    private Map<IPreferences, ReadWriteLock> locks = new HashMap<IPreferences, ReadWriteLock>();
    private volatile Set<IPreferences> flushableNodes = new HashSet<IPreferences>();
    private volatile Set<String> loadingApplications = new HashSet<String>();
    private volatile long lastModificationTime = 0L;
    private volatile Thread flushingThread = null;

    private IPreferences getRootNode() {
        if (this.rootNode == null) {
            this.rootNode = this.createRootNode();
        }
        return this.rootNode;
    }

    protected abstract IPreferences createRootNode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IPreferences getApplicationPreferences(String applicationName) throws BackingStoreException {
        AbstractPreferencesService.checkNodeName(applicationName);
        IPreferences rc = null;
        if (!this.getRootNode().nodeExists("@" + applicationName)) {
            boolean doLoad = true;
            Object object = this.SYNCH_OBJECT;
            synchronized (object) {
                if (this.loadingApplications.contains(applicationName) || this.getRootNode().nodeExists("@" + applicationName)) {
                    doLoad = false;
                } else {
                    this.loadingApplications.add(applicationName);
                }
            }
            if (doLoad) {
                rc = this.getRootNode().node("@" + applicationName);
                IPreferences prefs = rc.node(SYSTEM_NODE_NAME);
                this.locks.put(prefs, this.createReadWriteLock());
                this.loadSystemPreferences(prefs, applicationName);
                prefs = rc.node(USER_NODE_NAME);
                this.locks.put(prefs, this.createReadWriteLock());
                this.loadUserPreferences(prefs, applicationName);
                Object object2 = this.SYNCH_OBJECT;
                synchronized (object2) {
                    this.loadingApplications.remove(applicationName);
                }
            }
        } else {
            rc = this.getRootNode().node("@" + applicationName);
        }
        return rc;
    }

    protected ReadWriteLock createReadWriteLock() {
        return new ReentrantReadWriteLock(true);
    }

    @Override
    public Lock getReadLock(IPreferences node) {
        ReadWriteLock l = this.getReadWriteLock(node);
        if (l == null) {
            return null;
        }
        return l.readLock();
    }

    @Override
    public Lock getWriteLock(IPreferences node) {
        ReadWriteLock l = this.getReadWriteLock(node);
        if (l == null) {
            return null;
        }
        return l.writeLock();
    }

    protected ReadWriteLock getReadWriteLock(IPreferences node) {
        node = this.getLockNode(node);
        return this.locks.get(node);
    }

    protected IPreferences getLockNode(IPreferences node) {
        while (node.name() != null && !node.name().startsWith("@") && node.parent() != null) {
            node = node.parent();
        }
        return node;
    }

    protected abstract void loadUserPreferences(IPreferences var1, String var2) throws BackingStoreException;

    protected abstract void loadSystemPreferences(IPreferences var1, String var2) throws BackingStoreException;

    protected abstract void flushUserPreferences(IPreferences var1, String var2) throws BackingStoreException;

    protected abstract void flushSystemPreferences(IPreferences var1, String var2) throws BackingStoreException;

    @Override
    public IPreferences getUserPreferences(String applicationName) throws BackingStoreException {
        IPreferences rc = this.getApplicationPreferences(applicationName);
        if (rc == null) {
            throw new BackingStoreException("Cannot load application preferences for " + applicationName);
        }
        return rc.node(USER_NODE_NAME);
    }

    @Override
    public IPreferences getSystemPreferences(String applicationName) throws BackingStoreException {
        IPreferences rc = this.getApplicationPreferences(applicationName);
        if (rc == null) {
            throw new BackingStoreException("Cannot load application preferences for " + applicationName);
        }
        return rc.node(SYSTEM_NODE_NAME);
    }

    protected static void checkNodeName(String s) {
        if (!PATTERN.matcher(s).matches()) {
            throw new IllegalArgumentException("Node name is invalid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeChanged(IPreferences node) {
        node = this.getLockNode(node);
        Object object = this.SYNCH_OBJECT;
        synchronized (object) {
            if (!this.loadingApplications.contains(this.getApplicationName(node))) {
                this.flushableNodes.add(node);
                this.lastModificationTime = System.currentTimeMillis();
                if (this.flushingThread == null) {
                    this.flushingThread = new FlushingThread();
                    this.flushingThread.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(IPreferences node) throws BackingStoreException {
        Lock lock = this.getWriteLock(node);
        try {
            IPreferences prefs;
            if (lock != null) {
                lock.lock();
            }
            if ((prefs = this.getApplicationNode(node)) != null) {
                String applicationName = this.getApplicationName(prefs);
                this.flushUserPreferences(prefs.node(USER_NODE_NAME), applicationName);
                this.flushSystemPreferences(prefs.node(SYSTEM_NODE_NAME), applicationName);
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    protected IPreferences getApplicationNode(IPreferences node) {
        while (node != null) {
            if (node.parent() == this.getRootNode()) {
                return node;
            }
            node = node.parent();
        }
        return null;
    }

    protected String getApplicationName(IPreferences node) {
        if ((node = this.getApplicationNode(node)) != null) {
            return node.name().substring(1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(IPreferences node) throws BackingStoreException {
        boolean isRunning = true;
        while (isRunning) {
            Object object = this.SYNCH_OBJECT;
            synchronized (object) {
                isRunning = this.flushingThread != null;
            }
        }
    }

    protected class FlushingThread
    extends Thread {
        protected FlushingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int toBeFlushed;
            long timeDiff = 0L;
            do {
                LangUtils.sleep(120L);
                Set flushingNodes = null;
                Object object = AbstractPreferencesService.this.SYNCH_OBJECT;
                synchronized (object) {
                    timeDiff = System.currentTimeMillis() - AbstractPreferencesService.this.lastModificationTime;
                    toBeFlushed = AbstractPreferencesService.this.flushableNodes.size();
                    if (timeDiff > 500L && toBeFlushed > 0) {
                        flushingNodes = AbstractPreferencesService.this.flushableNodes;
                        AbstractPreferencesService.this.flushableNodes = new HashSet();
                    }
                }
                if (flushingNodes == null) continue;
                for (IPreferences node : flushingNodes) {
                    try {
                        AbstractPreferencesService.this.flush(node);
                    }
                    catch (BackingStoreException e) {
                        LoggerFactory.getLogger(AbstractPreferencesService.this.getClass()).error("Cannot flush node", (Throwable)e);
                    }
                }
                object = AbstractPreferencesService.this.SYNCH_OBJECT;
                synchronized (object) {
                    toBeFlushed = AbstractPreferencesService.this.flushableNodes.size();
                    if (toBeFlushed == 0) {
                        AbstractPreferencesService.this.flushingThread = null;
                    }
                }
            } while (toBeFlushed > 0);
        }
    }
}

