/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.prefs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.prefs.BackingStoreException;
import org.apache.commons.codec.binary.Base64;
import rs.baselib.bean.IPropertyChangeProvider;
import rs.baselib.lang.LangUtils;
import rs.baselib.prefs.AbstractPreferencesService;
import rs.baselib.prefs.IPreferences;
import rs.baselib.prefs.PreferencesService;
import rs.baselib.util.CommonUtils;

public abstract class AbstractPreferences
implements IPreferences,
IPropertyChangeProvider {
    private AbstractPreferences parent;
    private String name;
    private Map<String, AbstractPreferences> children;
    private Map<String, String> values;
    private String absolutePath = null;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private Lock readLock;
    private Lock writeLock;

    public AbstractPreferences() {
        this(null, null);
    }

    public AbstractPreferences(AbstractPreferences parent, String name) {
        this.parent = parent;
        this.name = name;
        this.children = new HashMap<String, AbstractPreferences>();
        this.values = new HashMap<String, String>();
        this.readLock = this.createReadLock();
        this.writeLock = this.createWriteLock();
    }

    protected abstract Lock createReadLock();

    protected abstract Lock createWriteLock();

    public Lock getReadLock() {
        return this.readLock;
    }

    protected void readLock() {
        Lock l = this.getReadLock();
        if (l != null) {
            l.lock();
        }
    }

    protected void readUnlock() {
        Lock l = this.getReadLock();
        if (l != null) {
            l.unlock();
        }
    }

    public Lock getWriteLock() {
        return this.writeLock;
    }

    protected void writeLock() {
        Lock l = this.getWriteLock();
        if (l != null) {
            l.lock();
        }
    }

    protected void writeUnlock() {
        Lock l = this.getWriteLock();
        if (l != null) {
            l.unlock();
        }
        this.getPreferencesService().nodeChanged(this);
    }

    protected abstract AbstractPreferences createNode(AbstractPreferences var1, String var2);

    protected void addNode(AbstractPreferences child) {
        try {
            this.writeLock();
            String n = child.name();
            if (n == null) {
                n = "";
            }
            this.children.put(n, child);
        }
        finally {
            this.writeUnlock();
        }
        this.firePropertyChange("childAdded", null, child);
    }

    protected void removeNode(AbstractPreferences child) {
        try {
            this.writeLock();
            this.children.remove(child.name());
        }
        finally {
            this.writeUnlock();
        }
        this.firePropertyChange("childRemoved", child, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, String value) {
        String oldValue = null;
        try {
            this.writeLock();
            oldValue = this.values.put(key, value);
        }
        finally {
            this.writeUnlock();
        }
        this.firePropertyChange(key, oldValue, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key, String def) {
        try {
            this.readLock();
            String rc = this.values.get(key);
            String string = rc != null ? rc : def;
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void remove(String key) {
        String oldValue = null;
        try {
            this.writeLock();
            oldValue = this.values.remove(key);
        }
        finally {
            this.writeUnlock();
        }
        this.firePropertyChange(key, oldValue, null);
    }

    @Override
    public void clear() throws BackingStoreException {
        try {
            this.writeLock();
            this.values.clear();
        }
        finally {
            this.writeUnlock();
        }
        this.firePropertyChange("valuesCleared", null, this);
    }

    @Override
    public void putInt(String key, int value) {
        this.put(key, Integer.toString(value));
    }

    @Override
    public int getInt(String key, int def) {
        return LangUtils.getInt(this.get(key, null), def);
    }

    @Override
    public void putLong(String key, long value) {
        this.put(key, Long.toString(value));
    }

    @Override
    public long getLong(String key, long def) {
        return LangUtils.getLong(this.get(key, null), def);
    }

    @Override
    public void putBoolean(String key, boolean value) {
        this.put(key, Boolean.toString(value));
    }

    @Override
    public boolean getBoolean(String key, boolean def) {
        String s = this.get(key, null);
        if (s != null) {
            return LangUtils.getBoolean(s);
        }
        return def;
    }

    @Override
    public void putFloat(String key, float value) {
        this.put(key, Float.toString(value));
    }

    @Override
    public float getFloat(String key, float def) {
        return LangUtils.getFloat(this.get(key, null), def);
    }

    @Override
    public void putDouble(String key, double value) {
        this.put(key, Double.toString(value));
    }

    @Override
    public double getDouble(String key, double def) {
        return LangUtils.getDouble(this.get(key, null), def);
    }

    @Override
    public void putByteArray(String key, byte[] value) {
        this.put(key, Base64.encodeBase64String((byte[])value));
    }

    @Override
    public byte[] getByteArray(String key, byte[] def) {
        String s = this.get(key, null);
        if (s != null) {
            return Base64.decodeBase64((String)s);
        }
        return def;
    }

    @Override
    public String[] keys() throws BackingStoreException {
        Lock lock = PreferencesService.INSTANCE.getReadLock(this);
        try {
            if (lock != null) {
                lock.lock();
            }
            String[] stringArray = this.values.keySet().toArray(new String[this.values.size()]);
            return stringArray;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    @Override
    public String[] childrenNames() throws BackingStoreException {
        try {
            this.readLock();
            String[] stringArray = this.children.keySet().toArray(new String[this.children.size()]);
            return stringArray;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public IPreferences parent() {
        return this.parent;
    }

    protected boolean isRelative(String pathName) {
        return !this.isAbsolute(pathName);
    }

    protected boolean isAbsolute(String pathName) {
        return pathName.startsWith("/");
    }

    protected boolean isRootNode() {
        return this.parent() == null;
    }

    protected AbstractPreferences getRootNode() {
        if (this.isRootNode()) {
            return this;
        }
        return ((AbstractPreferences)this.parent()).getRootNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPreferences node(String pathName) {
        IPreferences rc = null;
        if (this.isAbsolute(pathName) && !this.isRootNode()) {
            rc = this.getRootNode().node(pathName);
        } else {
            AbstractPreferences child;
            String[] names;
            block14: {
                if (pathName.startsWith("/")) {
                    if (pathName.length() > 1) {
                        pathName = pathName.substring(1);
                    } else {
                        return this;
                    }
                }
                names = pathName.split("\\/");
                child = null;
                try {
                    this.readLock();
                    child = this.children.get(names[0]);
                    if (child != null) break block14;
                    this.readUnlock();
                    try {
                        this.writeLock();
                        child = this.children.get(names[0]);
                        if (child == null) {
                            child = this.createNode(this, names[0]);
                            this.addNode(child);
                        }
                    }
                    finally {
                        this.writeUnlock();
                    }
                    this.readLock();
                }
                finally {
                    this.readUnlock();
                }
            }
            if (names.length > 1) {
                pathName = CommonUtils.join("/", names, 1);
                rc = child.node(pathName);
            } else {
                rc = child;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nodeExists(String pathName) throws BackingStoreException {
        if (this.isAbsolute(pathName) && !this.isRootNode()) {
            return this.getRootNode().nodeExists(pathName);
        }
        if (pathName.startsWith("/")) {
            if (pathName.length() > 1) {
                pathName = pathName.substring(1);
            } else {
                return true;
            }
        }
        String[] names = pathName.split("\\/");
        Lock lock = PreferencesService.INSTANCE.getReadLock(this);
        AbstractPreferences child = null;
        try {
            if (lock != null) {
                lock.lock();
            }
            if ((child = this.children.get(names[0])) == null) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        if (names.length > 1) {
            pathName = CommonUtils.join("/", names, 1);
            return child.nodeExists(pathName);
        }
        return true;
    }

    @Override
    public void removeNode() throws BackingStoreException {
        if (this.parent() != null) {
            ((AbstractPreferences)this.parent()).removeNode(this);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String absolutePath() {
        if (this.absolutePath == null) {
            if (this.isRootNode()) {
                this.absolutePath = "/";
            } else {
                StringBuilder s = new StringBuilder();
                s.append(this.parent.absolutePath());
                s.append("/");
                s.append(this.name());
                s.deleteCharAt(0);
                this.absolutePath = s.toString();
            }
        }
        return this.absolutePath;
    }

    protected abstract AbstractPreferencesService getPreferencesService();

    @Override
    public void flush() throws BackingStoreException {
        AbstractPreferencesService svc = this.getPreferencesService();
        if (svc != null) {
            svc.flush(this);
        }
    }

    @Override
    public void sync() throws BackingStoreException {
        AbstractPreferencesService svc = this.getPreferencesService();
        if (svc != null) {
            svc.sync(this);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected boolean firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        return this.firePropertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
    }

    protected boolean firePropertyChange(PropertyChangeEvent event) {
        if (!CommonUtils.equals(event.getOldValue(), event.getNewValue())) {
            this.changeSupport.firePropertyChange(event);
            return true;
        }
        return false;
    }
}

