/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.php;

import java.util.Collection;
import java.util.Map;
import rs.baselib.php.PhpSerializeException;

public class PhpSerializer {
    public static String serialize(Object object) {
        StringBuilder buffer = new StringBuilder();
        PhpSerializer.serializeObject(object, buffer);
        return buffer.toString();
    }

    private static void serializeObject(Object object, StringBuilder buffer) {
        if (object == null) {
            PhpSerializer.serializeNull(buffer);
        } else if (object instanceof String) {
            PhpSerializer.serializeString((String)object, buffer);
        } else if (object instanceof Character) {
            PhpSerializer.serializeCharacter((Character)object, buffer);
        } else if (object instanceof Integer) {
            PhpSerializer.serializeInteger((Integer)object, buffer);
        } else if (object instanceof Short) {
            PhpSerializer.serializeInteger(((Short)object).intValue(), buffer);
        } else if (object instanceof Byte) {
            PhpSerializer.serializeInteger(((Byte)object).intValue(), buffer);
        } else if (object instanceof Long) {
            PhpSerializer.serializeLong((Long)object, buffer);
        } else if (object instanceof Double) {
            PhpSerializer.serializeDouble((Double)object, buffer);
        } else if (object instanceof Float) {
            PhpSerializer.serializeDouble(((Float)object).doubleValue(), buffer);
        } else if (object instanceof Boolean) {
            PhpSerializer.serializeBoolean((Boolean)object, buffer);
        } else if (object instanceof Object[]) {
            PhpSerializer.serializeArray((Object[])object, buffer);
        } else if (object instanceof Collection) {
            PhpSerializer.serializeArray(((Collection)object).toArray(), buffer);
        } else if (object instanceof Map) {
            PhpSerializer.serializeMap((Map)object, buffer);
        } else {
            throw new PhpSerializeException("Unable to serialize " + object.getClass().getName());
        }
    }

    private static void serializeString(String string, StringBuilder buffer) {
        buffer.append("s:");
        buffer.append(string.length());
        buffer.append(":\"");
        buffer.append(string);
        buffer.append("\";");
    }

    private static void serializeCharacter(Character value, StringBuilder buffer) {
        buffer.append("s:1:\"");
        buffer.append(value);
        buffer.append("\";");
    }

    private static void serializeNull(StringBuilder buffer) {
        buffer.append("N;");
    }

    private static void serializeInteger(int number, StringBuilder buffer) {
        buffer.append("i:");
        buffer.append(number);
        buffer.append(";");
    }

    private static void serializeLong(long number, StringBuilder buffer) {
        if (number >= Integer.MIN_VALUE && number <= Integer.MAX_VALUE) {
            buffer.append("i:");
        } else {
            buffer.append("d:");
        }
        buffer.append(number);
        buffer.append(";");
    }

    private static void serializeDouble(double number, StringBuilder buffer) {
        buffer.append("d:");
        buffer.append(number);
        buffer.append(";");
    }

    private static void serializeBoolean(Boolean value, StringBuilder buffer) {
        buffer.append("b:");
        buffer.append(value != false ? 1 : 0);
        buffer.append(";");
    }

    private static void serializeArray(Object[] array, StringBuilder buffer) {
        buffer.append("a:");
        int max = array.length;
        buffer.append(max);
        buffer.append(":{");
        for (int i = 0; i < max; ++i) {
            PhpSerializer.serializeObject(i, buffer);
            PhpSerializer.serializeObject(array[i], buffer);
        }
        buffer.append('}');
    }

    private static void serializeMap(Map<?, ?> map, StringBuilder buffer) {
        buffer.append("a:");
        buffer.append(map.size());
        buffer.append(":{");
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            PhpSerializer.serializeObject(entry.getKey(), buffer);
            PhpSerializer.serializeObject(entry.getValue(), buffer);
        }
        buffer.append('}');
    }
}

