/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.licensing;

import rs.baselib.licensing.ILicense;
import rs.baselib.licensing.ILicenseContext;
import rs.baselib.licensing.ILicenseVerifier;
import rs.baselib.licensing.ILicensingScheme;
import rs.baselib.licensing.LicenseException;
import rs.baselib.licensing.LicensingScheme;

public class LicenseManager {
    private ILicenseVerifier licenseVerifier;

    public LicenseManager() {
        this((ILicensingScheme)null);
    }

    public LicenseManager(ILicensingScheme scheme) {
        this(scheme != null ? scheme.getLicenseVerifier() : LicensingScheme.RSA_LICENSE.getLicenseVerifier());
    }

    public LicenseManager(ILicenseVerifier licenseVerifier) {
        this.licenseVerifier = licenseVerifier;
    }

    public ILicenseVerifier getLicenseVerifier() {
        return this.licenseVerifier;
    }

    public ILicense verify(String licenseKey, ILicenseContext context) {
        try {
            return this.getLicenseVerifier().verify(licenseKey, context);
        }
        catch (LicenseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new LicenseException("Cannot create license key", t);
        }
    }
}

