/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.licensing;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import rs.baselib.licensing.ILicense;
import rs.baselib.licensing.ILicenseContext;
import rs.baselib.licensing.LicenseException;
import rs.baselib.util.DefaultComparator;

public abstract class AbstractLicense
implements ILicense {
    private static final long serialVersionUID = 3018690737456535564L;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public Object removeProperty(String key) {
        return this.properties.remove(key);
    }

    public Iterable<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    protected Object initProperty(String key, ILicenseContext context) {
        if (context.hasKey(key)) {
            Object value = context.get(key);
            this.setProperty(key, value);
            return value;
        }
        return null;
    }

    protected void verifyEquals(String key, ILicenseContext context, boolean failIfMissing) {
        Object myValue = this.getProperty(key);
        Object verificationValue = context.get(key);
        if (myValue != null) {
            if (!verificationValue.equals(myValue)) {
                throw new LicenseException(key + " is invalid");
            }
        } else if (failIfMissing) {
            throw new LicenseException(key + " is missing");
        }
    }

    protected void verifyGreaterThan(String key, ILicenseContext context, boolean failIfMissing) {
        Object myValue = this.getProperty(key);
        Object verificationValue = context.get(key);
        if (myValue != null) {
            if (DefaultComparator.INSTANCE.compare(myValue, verificationValue) <= 0) {
                throw new LicenseException(key + " is invalid");
            }
        } else if (failIfMissing) {
            throw new LicenseException(key + " is missing");
        }
    }

    protected void verifyEqualGreaterThan(String key, ILicenseContext context, boolean failIfMissing) {
        Object myValue = this.getProperty(key);
        Object verificationValue = context.get(key);
        if (myValue != null) {
            if (DefaultComparator.INSTANCE.compare(myValue, verificationValue) < 0) {
                throw new LicenseException(key + " is invalid");
            }
        } else if (failIfMissing) {
            throw new LicenseException(key + " is missing");
        }
    }

    protected void verifyLessThan(String key, ILicenseContext context, boolean failIfMissing) {
        Object myValue = this.getProperty(key);
        Object verificationValue = context.get(key);
        if (myValue != null) {
            if (DefaultComparator.INSTANCE.compare(myValue, verificationValue) >= 0) {
                throw new LicenseException(key + " is invalid");
            }
        } else if (failIfMissing) {
            throw new LicenseException(key + " is missing");
        }
    }

    protected void verifyEqualLessThan(String key, ILicenseContext context, boolean failIfMissing) {
        Object myValue = this.getProperty(key);
        Object verificationValue = context.get(key);
        if (myValue != null) {
            if (DefaultComparator.INSTANCE.compare(myValue, verificationValue) > 0) {
                throw new LicenseException(key + " is invalid");
            }
        } else if (failIfMissing) {
            throw new LicenseException(key + " is missing");
        }
    }
}

