/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.crypto;

import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.Sha2Crypt;
import rs.baselib.crypto.ExtendedPasswordHasher;

public class Sha256PasswordHasher
implements ExtendedPasswordHasher {
    public static final String PREFIX = "$5$";
    public static final ExtendedPasswordHasher INSTANCE = new Sha256PasswordHasher();

    @Override
    public String getPasswordHash(String plainPassword) {
        return Sha2Crypt.sha256Crypt((byte[])StringUtils.getBytesUtf8((String)plainPassword));
    }

    @Override
    public boolean testPassword(String plainPassword, String passwordHash) {
        if (plainPassword != null && this.isHash(passwordHash)) {
            String otherHash = Sha2Crypt.sha256Crypt((byte[])StringUtils.getBytesUtf8((String)plainPassword), (String)passwordHash);
            return otherHash.equals(passwordHash);
        }
        return false;
    }

    @Override
    public boolean isHash(String passwordHash) {
        return passwordHash != null && passwordHash.startsWith(PREFIX);
    }
}

