/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.crypto;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.baselib.util.CommonUtils;

public class EncryptionUtils {
    private static Logger log = LoggerFactory.getLogger(EncryptionUtils.class);
    public static final String DEFAULT_SECRET_KEY_TYPE = "PBEWithMD5AndDES";
    public static final int DEFAULT_ITERATIONS = 19;
    public static final String PASSWORD_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!\"&/()=?;*+'#;,:._-<>";
    private static Base64 base64 = new Base64(80);

    public static KeySpec getKeySpec(Key key) throws InvalidKeySpecException, NoSuchAlgorithmException {
        KeyFactory fact = KeyFactory.getInstance(key.getAlgorithm());
        return fact.getKeySpec(key, KeySpec.class);
    }

    public static PBEParameterSpec generateParamSpec() {
        return EncryptionUtils.generateParamSpec(null, 0);
    }

    public static PBEParameterSpec generateParamSpec(byte[] salt, int iterationCount) {
        if (salt == null) {
            salt = EncryptionUtils.generateSalt(System.currentTimeMillis());
        }
        if (iterationCount < 1) {
            iterationCount = 19;
        }
        return new PBEParameterSpec(salt, iterationCount);
    }

    public static byte[] generateSalt() {
        return EncryptionUtils.generateSalt(0L);
    }

    public static byte[] generateSalt(long randomInit) {
        return EncryptionUtils.generateRandomBytes(randomInit, 8);
    }

    public static byte[] generateRandomBytes(long randomInit, int size) {
        if (randomInit == 0L) {
            randomInit = System.currentTimeMillis();
        }
        Random random = new Random(randomInit);
        byte[] rc = new byte[size];
        random.nextBytes(rc);
        return rc;
    }

    public static String generatePassword() {
        return EncryptionUtils.generatePassword(null, 0L, 0);
    }

    public static String generatePassword(int length) {
        return EncryptionUtils.generatePassword(null, 0L, length);
    }

    public static String generatePassword(String allowedChars) {
        return EncryptionUtils.generatePassword(allowedChars, 0L, 0);
    }

    public static String generatePassword(String allowedChars, long randomInit, int length) {
        if (allowedChars == null || allowedChars.trim().length() == 0) {
            allowedChars = PASSWORD_CHARS;
        }
        if (randomInit == 0L) {
            randomInit = System.currentTimeMillis();
        }
        if (length < 1) {
            length = 19;
        }
        Random random = new Random(randomInit);
        StringBuilder rc = new StringBuilder(length);
        while (rc.length() < length) {
            int n = random.nextInt(allowedChars.length());
            char c = allowedChars.charAt(n);
            if (Character.isWhitespace(c)) continue;
            rc.append(c);
        }
        return rc.toString();
    }

    public static SecretKey getSecretKey(int iterationCount, String passPhrase, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (iterationCount < 1) {
            iterationCount = 19;
        }
        if (salt == null) {
            salt = EncryptionUtils.generateSalt(0L);
        }
        PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), salt, iterationCount);
        SecretKey key = SecretKeyFactory.getInstance(DEFAULT_SECRET_KEY_TYPE).generateSecret(keySpec);
        return key;
    }

    public static KeyPair generateKey(String seed) throws NoSuchProviderException, NoSuchAlgorithmException {
        return EncryptionUtils.generateKey(seed, null);
    }

    public static KeyPair generateKey(String seed, Charset charset) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        return EncryptionUtils.generateKey(seed.getBytes(charset));
    }

    public static KeyPair generateKey(byte[] seed) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (seed == null) {
            seed = EncryptionUtils.generateSalt();
        }
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DSA");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(seed);
        keyGen.initialize(1024, random);
        KeyPair pair = keyGen.generateKeyPair();
        return pair;
    }

    public static KeyPair generateKey() throws NoSuchAlgorithmException {
        return EncryptionUtils.generateKey("RSA", 512);
    }

    public static KeyPair generateKey(int keySize) throws NoSuchAlgorithmException {
        return EncryptionUtils.generateKey("RSA", keySize);
    }

    public static KeyPair generateKey(String algorithm, int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm);
        keyGen.initialize(keySize);
        return keyGen.genKeyPair();
    }

    public static Provider[] getKeyPairGenerators() {
        return Security.getProviders();
    }

    public static String encodeBase64(PublicKey key) {
        byte[] b = key.getEncoded();
        return EncryptionUtils.encodeBase64(b);
    }

    public static String encodeBase64X509(PublicKey key) {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(key.getEncoded());
        return base64.encodeToString(x509EncodedKeySpec.getEncoded());
    }

    public static String encodeBase64(PrivateKey key) {
        byte[] b = key.getEncoded();
        return EncryptionUtils.encodeBase64(b);
    }

    public static String encodeBase64Pkcs8(PrivateKey key) {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(key.getEncoded());
        return base64.encodeToString(pkcs8EncodedKeySpec.getEncoded());
    }

    public static PublicKey decodeBase64PublicKey(String s) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return EncryptionUtils.decodeBase64PublicKey(s, "DSA");
    }

    public static PublicKey decodeBase64PublicKey(String s, String algorithm) throws InvalidKeySpecException, NoSuchAlgorithmException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(EncryptionUtils.decodeBase64(s));
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePublic(keySpec);
    }

    public static PrivateKey decodeBase64PrivateKey(String s) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return EncryptionUtils.decodeBase64PrivateKey(s, "DSA");
    }

    public static PrivateKey decodeBase64PrivateKey(String s, String algorithm) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(EncryptionUtils.decodeBase64(s));
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePrivate(privateKeySpec);
    }

    public static String decodeBase64ToString(String s) {
        return EncryptionUtils.decodeBase64ToString(s, null);
    }

    public static String decodeBase64ToString(String s, Charset charset) {
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        return new String(EncryptionUtils.decodeBase64(s), charset);
    }

    public static byte[] decodeBase64(String s) {
        return Base64.decodeBase64((String)s);
    }

    public static String encodeBase64(String s) {
        return EncryptionUtils.encodeBase64(s, null);
    }

    public static String encodeBase64(String s, Charset charset) {
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        return EncryptionUtils.encodeBase64(s.getBytes(charset));
    }

    public static String encodeBase64(byte[] b) {
        return Base64.encodeBase64String((byte[])b).trim();
    }

    public static KeyStore getKeyStore(String filename, char[] password) throws IOException {
        return EncryptionUtils.getKeyStore(KeyStore.getDefaultType(), new FileInputStream(filename), password);
    }

    public static KeyStore getKeyStore(String type, String filename, char[] password) throws IOException {
        log.debug("Reading " + type + " keystore: " + filename);
        return EncryptionUtils.getKeyStore(type, new FileInputStream(filename), password);
    }

    public static KeyStore getKeyStore(InputStream in, char[] password) throws IOException {
        return EncryptionUtils.getKeyStore(KeyStore.getDefaultType(), in, password);
    }

    public static KeyStore getKeyStore(String type, InputStream in, char[] password) throws IOException {
        try {
            KeyStore ks = KeyStore.getInstance(type);
            ks.load(in, password);
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Cannot load key store", e);
        }
        catch (CertificateException e) {
            throw new RuntimeException("Cannot load key store", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot load key store", e);
        }
        finally {
            in.close();
        }
    }

    public static byte[] crypt(byte[] bytes, Cipher cipher) throws IOException, GeneralSecurityException {
        return EncryptionUtils.crypt(bytes, cipher, 0);
    }

    public static byte[] crypt(byte[] bytes, Cipher cipher, int blockSize) throws IOException, GeneralSecurityException {
        if (blockSize == 0 || bytes.length <= blockSize) {
            return cipher.doFinal(bytes);
        }
        int firstOutputLength = cipher.getOutputSize(blockSize);
        int lastBlockSize = bytes.length % blockSize;
        int lastOutputLength = cipher.getOutputSize(lastBlockSize);
        int firstBlockCount = bytes.length / blockSize;
        int outputLen = firstOutputLength * firstBlockCount + lastOutputLength;
        ByteArrayOutputStream out = new ByteArrayOutputStream(outputLen);
        for (int i = 0; i < firstBlockCount; ++i) {
            out.write(cipher.doFinal(bytes, i * blockSize, blockSize));
        }
        if (lastBlockSize > 0) {
            out.write(cipher.doFinal(bytes, firstBlockCount * blockSize, lastBlockSize));
        }
        byte[] rc = out.toByteArray();
        out.close();
        return rc;
    }

    public static byte[] createMD5(String s) {
        byte[] b = null;
        try {
            b = s.getBytes("UTF-8");
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot get UTF8 bytes from \"" + s + "\".", t);
        }
        return EncryptionUtils.createMD5(b);
    }

    public static byte[] createMD5(byte[] b) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(b);
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot hash string", t);
        }
    }

    public static PrivateKey loadPrivateKey(File file, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        return EncryptionUtils.decodeBase64PrivateKey(CommonUtils.loadContent(file), algorithm);
    }

    public static PrivateKey loadPrivateKey(String filename, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        return EncryptionUtils.decodeBase64PrivateKey(CommonUtils.loadContent(filename), algorithm);
    }

    public static PrivateKey loadPrivateKey(URL url, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        return EncryptionUtils.decodeBase64PrivateKey(CommonUtils.loadContent(url), algorithm);
    }

    public static PrivateKey loadPrivateKey(InputStream in, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        return EncryptionUtils.decodeBase64PrivateKey(CommonUtils.loadContent(in), algorithm);
    }

    public static PrivateKey loadPrivateKey(Reader in, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        return EncryptionUtils.decodeBase64PrivateKey(CommonUtils.loadContent(in), algorithm);
    }

    public static PublicKey loadPublicKey(File file, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        return EncryptionUtils.decodeBase64PublicKey(CommonUtils.loadContent(file), algorithm);
    }

    public static PublicKey loadPublicKey(String filename, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        return EncryptionUtils.decodeBase64PublicKey(CommonUtils.loadContent(filename), algorithm);
    }

    public static PublicKey loadPublicKey(URL url, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        return EncryptionUtils.decodeBase64PublicKey(CommonUtils.loadContent(url), algorithm);
    }

    public static PublicKey loadPublicKey(InputStream in, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        return EncryptionUtils.decodeBase64PublicKey(CommonUtils.loadContent(in), algorithm);
    }

    public static PublicKey loadPublicKey(Reader in, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        return EncryptionUtils.decodeBase64PublicKey(CommonUtils.loadContent(in), algorithm);
    }

    public static void save(File file, PrivateKey key) throws IOException {
        CommonUtils.writeContent(file, EncryptionUtils.encodeBase64Pkcs8(key));
    }

    public static void save(String filename, PrivateKey key) throws IOException {
        CommonUtils.writeContent(filename, EncryptionUtils.encodeBase64Pkcs8(key));
    }

    public static void save(OutputStream out, PrivateKey key) throws IOException {
        CommonUtils.writeContent(out, EncryptionUtils.encodeBase64Pkcs8(key));
    }

    public static void save(PrintWriter out, PrivateKey key) throws IOException {
        CommonUtils.writeContent(out, EncryptionUtils.encodeBase64Pkcs8(key));
    }

    public static void save(File file, PublicKey key) throws IOException {
        CommonUtils.writeContent(file, EncryptionUtils.encodeBase64X509(key));
    }

    public static void save(String filename, PublicKey key) throws IOException {
        CommonUtils.writeContent(filename, EncryptionUtils.encodeBase64X509(key));
    }

    public static void save(OutputStream out, PublicKey key) throws IOException {
        CommonUtils.writeContent(out, EncryptionUtils.encodeBase64X509(key));
    }

    public static void save(PrintWriter out, PublicKey key) throws IOException {
        CommonUtils.writeContent(out, EncryptionUtils.encodeBase64X509(key));
    }
}

