/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.crypto;

import java.io.IOException;
import java.net.URL;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.baselib.configuration.ConfigurationUtils;
import rs.baselib.crypto.DefaultCryptingDelegate;
import rs.baselib.crypto.EncryptionUtils;
import rs.baselib.crypto.ICryptingDelegate;
import rs.baselib.crypto.ICryptingDelegateFactory;
import rs.baselib.io.FileFinder;
import rs.baselib.lang.LangUtils;
import rs.baselib.security.IPasswordCallback;

public class DefaultCryptingDelegateFactory
implements ICryptingDelegateFactory {
    private static Logger log = LoggerFactory.getLogger(DefaultCryptingDelegateFactory.class);
    public static final DefaultCryptingDelegateFactory INSTANCE = new DefaultCryptingDelegateFactory();
    private ICryptingDelegate cryptingDelegate = null;
    private KeyPair keyPair = null;
    private String algorithm;
    private AlgorithmParameterSpec paramSpec;
    private XMLConfiguration config;
    private Map<String, IPasswordCallback> passwordCallbacks;
    private boolean specLoaded = false;

    public static ICryptingDelegateFactory getInstance() {
        return INSTANCE;
    }

    private DefaultCryptingDelegateFactory() {
        this.init();
    }

    protected void init() {
        try {
            this.passwordCallbacks = new HashMap<String, IPasswordCallback>();
            String configLocation = System.getProperty("encryption.config");
            if (configLocation == null) {
                configLocation = "encryption-config.xml";
            }
            URL configURL = FileFinder.find(configLocation);
            log.info("Encryption configuration defined as: " + configLocation);
            log.info("Encryption configuration found at: " + configURL);
            this.config = ConfigurationUtils.getXmlConfiguration(configURL);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load keys", e);
        }
    }

    protected synchronized void loadSpec() {
        if (!this.specLoaded) {
            if (this.algorithm == null) {
                this.algorithm = this.loadAlgorithm((Configuration)this.config);
            }
            if (this.paramSpec == null) {
                this.paramSpec = this.loadParamSpec((Configuration)this.config);
            }
            this.specLoaded = true;
        }
    }

    protected XMLConfiguration getConfiguration() {
        return this.config;
    }

    protected String getDelegateClassName() {
        String className = this.config.getString("cryptingDelegate(0)[@class]");
        if (className == null) {
            className = DefaultCryptingDelegate.class.getName();
        }
        return className;
    }

    protected synchronized IPasswordCallback getPasswordCallback(String type) {
        SubnodeConfiguration config = this.getPasswordCallbackConfig(type);
        String className = config.getString("[@class]");
        if (className != null) {
            IPasswordCallback rc = this.passwordCallbacks.get(className);
            if (rc == null) {
                rc = (IPasswordCallback)ConfigurationUtils.load((Configuration)config, true);
                this.passwordCallbacks.put(className, rc);
            }
            return rc;
        }
        return null;
    }

    protected SubnodeConfiguration getPasswordCallbackConfig(String type) {
        int index = 0;
        while (true) {
            SubnodeConfiguration rc = null;
            try {
                rc = (SubnodeConfiguration)this.config.configurationAt("passwordCallback(" + index + ")");
            }
            catch (IllegalArgumentException e) {
                break;
            }
            if (rc == null) break;
            String t = rc.getString("[@type]");
            if (type.equals(t)) {
                return rc;
            }
            ++index;
        }
        return null;
    }

    protected char[] getPassword(String type) {
        char[] rc = null;
        IPasswordCallback callback = this.getPasswordCallback(type);
        rc = callback == null ? null : callback.getPassword();
        return rc;
    }

    protected byte[] getKeySalt() {
        return this.getSalt("key");
    }

    @Override
    public byte[] getSalt() {
        return this.getKeySalt();
    }

    protected byte[] getSalt(String type) {
        byte[] rc = null;
        IPasswordCallback callback = this.getPasswordCallback(type);
        rc = callback == null ? null : callback.getSalt();
        return rc;
    }

    protected SubnodeConfiguration getKeyStoreConfig() {
        try {
            return (SubnodeConfiguration)this.config.configurationAt("keystore(0)");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    protected KeyStore getKeyStore() throws IOException {
        String path = this.getKeyStorePath();
        if (path != null) {
            log.info("Keystore defined as: " + path);
            URL url = FileFinder.find(path);
            log.info("Keystore found at: " + url);
            return EncryptionUtils.getKeyStore(this.getKeyStoreType(), url.openStream(), this.getKeyStorePassword());
        }
        return null;
    }

    protected String getKeyStoreType() {
        String rc = ConfigurationUtils.getParam(this.getKeyStoreConfig(), "type");
        if (rc == null) {
            rc = KeyStore.getDefaultType();
        }
        return rc;
    }

    protected String getKeyStorePath() {
        return ConfigurationUtils.getParam(this.getKeyStoreConfig(), "location");
    }

    protected char[] getKeyStorePassword() {
        return this.getPassword("keystore");
    }

    protected String getKeyAlias() {
        return ConfigurationUtils.getParam(this.getKeyStoreConfig(), "key.alias");
    }

    protected char[] getKeyPassword() {
        return this.getPassword("key");
    }

    @Override
    public char[] getPassphrase() {
        return this.getKeyPassword();
    }

    @Override
    public ICryptingDelegate getCryptingDelegate() {
        if (this.cryptingDelegate == null) {
            this.createCryptingDelegate();
        }
        return this.cryptingDelegate;
    }

    protected synchronized void createCryptingDelegate() {
        if (this.cryptingDelegate != null) {
            return;
        }
        try {
            Class<?> clazz = LangUtils.forName(this.getDelegateClassName());
            this.cryptingDelegate = (ICryptingDelegate)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.cryptingDelegate.init(this);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create crypting delegate", e);
        }
    }

    @Override
    public KeyPair getKeyPair() {
        if (this.keyPair == null) {
            try {
                KeyStore ks = this.getKeyStore();
                String keyAlias = this.getKeyAlias();
                char[] keyPassword = this.getKeyPassword();
                if (ks != null && keyAlias != null && keyPassword != null) {
                    PrivateKey privKey = (PrivateKey)ks.getKey(this.getKeyAlias(), this.getKeyPassword());
                    PublicKey pubKey = ks.getCertificate(this.getKeyAlias()).getPublicKey();
                    this.setKeyPair(new KeyPair(pubKey, privKey));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create key pair:", e);
            }
        }
        return this.keyPair;
    }

    public void setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    @Override
    public String getAlgorithm() {
        if (!this.specLoaded) {
            this.loadSpec();
        }
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    protected String loadAlgorithm(Configuration config) {
        try {
            return config.getString("algorithm(0)");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    public AlgorithmParameterSpec getParamSpec() {
        if (!this.specLoaded) {
            this.loadSpec();
        }
        return this.paramSpec;
    }

    public void setParamSpec(AlgorithmParameterSpec paramSpec) {
        this.paramSpec = paramSpec;
    }

    protected AlgorithmParameterSpec loadParamSpec(Configuration config) {
        return EncryptionUtils.generateParamSpec(this.getSalt(), 19);
    }
}

