/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.crypto;

import rs.baselib.crypto.BCrypt;
import rs.baselib.crypto.ExtendedPasswordHasher;

public class BlowfishPasswordHasher
implements ExtendedPasswordHasher {
    public static final ExtendedPasswordHasher INSTANCE = new BlowfishPasswordHasher();

    @Override
    public String getPasswordHash(String plainPassword) {
        return BCrypt.hashpw(plainPassword, BCrypt.gensalt());
    }

    @Override
    public boolean testPassword(String plainPassword, String passwordHash) {
        if (this.isHash(passwordHash)) {
            return BCrypt.checkpw(plainPassword, passwordHash);
        }
        return false;
    }

    @Override
    public boolean isHash(String passwordHash) {
        return passwordHash != null && passwordHash.startsWith("$2a$");
    }
}

