/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.configuration;

import java.io.File;
import java.net.URL;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.XMLBuilderParameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import rs.baselib.configuration.IConfigurable;
import rs.baselib.lang.LangUtils;

public class ConfigurationUtils {
    public static Object load(Configuration config, boolean configure) {
        String className = config.getString("[@class]");
        return ConfigurationUtils.load(className, config, configure);
    }

    public static Object load(String className, Configuration config, boolean configure) {
        try {
            Class<?> clazz = LangUtils.forName(className);
            return ConfigurationUtils.load(clazz, config, configure);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot load class from configuration", e);
        }
    }

    public static <T> T load(Class<T> clazz, Configuration config, boolean configure) {
        try {
            T rc = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (configure && rc instanceof IConfigurable) {
                ConfigurationUtils.configure((IConfigurable)rc, config);
            }
            return rc;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load class from configuration", e);
        }
    }

    public static void configure(IConfigurable configurable, Configuration config) throws ConfigurationException {
        configurable.configure(config);
    }

    public static String getParam(SubnodeConfiguration config, String name) {
        if (config == null) {
            return null;
        }
        int index = 0;
        try {
            while (true) {
                SubnodeConfiguration cfg;
                if ((cfg = (SubnodeConfiguration)config.configurationAt("param(" + index + ")")) == null) {
                    return null;
                }
                String n = cfg.getString("[@name]");
                if (name.equals(n)) {
                    return config.getString("param(" + index + ")");
                }
                ++index;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getParam(HierarchicalConfiguration<ImmutableNode> config, String name) {
        if (config == null) {
            return null;
        }
        int index = 0;
        try {
            while (true) {
                HierarchicalConfiguration cfg;
                if ((cfg = config.configurationAt("param(" + index + ")")) == null) {
                    return null;
                }
                String n = cfg.getString("[@name]");
                if (name.equals(n)) {
                    return config.getString("param(" + index + ")");
                }
                ++index;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PropertiesBuilderParameters createPropertiesBuilderParams(String encoding) {
        Parameters params = new Parameters();
        return (PropertiesBuilderParameters)((PropertiesBuilderParameters)params.properties().setThrowExceptionOnMissing(false)).setEncoding(encoding);
    }

    public static PropertiesConfiguration getPropertiesConfiguration(PropertiesBuilderParameters params) throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{params});
        return (PropertiesConfiguration)builder.getConfiguration();
    }

    public static PropertiesConfiguration getPropertiesConfiguration(File file) throws ConfigurationException {
        return ConfigurationUtils.getPropertiesConfiguration(file, "UTF-8");
    }

    public static PropertiesConfiguration getPropertiesConfiguration(File file, String encoding) throws ConfigurationException {
        return ConfigurationUtils.getPropertiesConfiguration((PropertiesBuilderParameters)ConfigurationUtils.createPropertiesBuilderParams(encoding).setFile(file));
    }

    public static PropertiesConfiguration getPropertiesConfiguration(URL url) throws ConfigurationException {
        return ConfigurationUtils.getPropertiesConfiguration(url, "UTF-8");
    }

    public static PropertiesConfiguration getPropertiesConfiguration(URL url, String encoding) throws ConfigurationException {
        return ConfigurationUtils.getPropertiesConfiguration((PropertiesBuilderParameters)ConfigurationUtils.createPropertiesBuilderParams(encoding).setURL(url));
    }

    public static XMLBuilderParameters createXMLBuilderParams(String encoding) {
        Parameters params = new Parameters();
        return (XMLBuilderParameters)((XMLBuilderParameters)((XMLBuilderParameters)params.xml().setThrowExceptionOnMissing(false)).setValidating(false)).setEncoding(encoding);
    }

    public static XMLConfiguration getXmlConfiguration(XMLBuilderParameters params) throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class).configure(new BuilderParameters[]{params});
        return (XMLConfiguration)builder.getConfiguration();
    }

    public static XMLConfiguration getXmlConfiguration(File file) throws ConfigurationException {
        return ConfigurationUtils.getXmlConfiguration(file, "UTF-8");
    }

    public static XMLConfiguration getXmlConfiguration(File file, String encoding) throws ConfigurationException {
        return ConfigurationUtils.getXmlConfiguration((XMLBuilderParameters)ConfigurationUtils.createXMLBuilderParams(encoding).setFile(file));
    }

    public static XMLConfiguration getXmlConfiguration(URL configUrl) throws ConfigurationException {
        return ConfigurationUtils.getXmlConfiguration(configUrl, "UTF-8");
    }

    public static XMLConfiguration getXmlConfiguration(URL configUrl, String encoding) throws ConfigurationException {
        return ConfigurationUtils.getXmlConfiguration((XMLBuilderParameters)ConfigurationUtils.createXMLBuilderParams(encoding).setURL(configUrl));
    }
}

