/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.bean;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.baselib.lang.LangUtils;

public class BeanSupport {
    private static Logger log = LoggerFactory.getLogger(BeanSupport.class);
    public static BeanSupport INSTANCE = new BeanSupport();
    private Map<Class<?>, Map<String, String>> beanPropertyMappings = new HashMap();
    private Map<Class<?>, Set<String>> forbiddenCopies = new HashMap();
    private Map<Class<?>, List<String>> nonTransientProperties = new HashMap();
    private Map<Class<?>, List<String>> transientProperties = new HashMap();

    protected BeanSupport() {
    }

    public void addPropertyName(Class<?> beanClass, String propertyName, String propertyEventName) {
        Map<String, String> propertyMap = this.getPropertyMap(beanClass);
        propertyMap.put(propertyName, propertyEventName);
    }

    public synchronized Map<String, String> getPropertyMap(Class<?> beanClass) {
        Map<String, String> rc = this.beanPropertyMappings.get(beanClass);
        if (rc == null) {
            rc = new HashMap<String, String>();
            this.beanPropertyMappings.put(beanClass, rc);
        }
        return rc;
    }

    public void firePropertyEvents(Collection<PropertyChangeListener> listeners, Object bean) {
        if (bean == null) {
            return;
        }
        Map<String, String> propertyMap = this.getPropertyMap(bean.getClass());
        for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
            try {
                Object oldValue = null;
                Object newValue = PropertyUtils.getSimpleProperty((Object)bean, (String)entry.getKey());
                PropertyChangeEvent evt = new PropertyChangeEvent(bean, entry.getValue(), oldValue, newValue);
                for (PropertyChangeListener l : listeners) {
                    l.propertyChange(evt);
                }
            }
            catch (Throwable t) {
                log.error("Error while firing property event: " + entry.getKey(), t);
            }
        }
    }

    public boolean isCopyForbidden(Class<?> beanClass, String propertyName) {
        if (propertyName.equals("class")) {
            return true;
        }
        if (this.isTransient(beanClass, propertyName)) {
            return true;
        }
        return this.getForbiddenList(beanClass, true).contains(propertyName);
    }

    protected Set<String> getForbiddenList(Class<?> beanClass, boolean create) {
        Set<String> rc = this.forbiddenCopies.get(beanClass);
        if (rc == null && create) {
            rc = new HashSet<String>();
            this.collectForbiddenCopies(rc, beanClass);
            this.forbiddenCopies.put(beanClass, Collections.unmodifiableSet(rc));
        }
        if (rc == null) {
            return Collections.emptySet();
        }
        return rc;
    }

    protected void collectForbiddenCopies(Set<String> rc, Class<?> clazz) {
        PropertyDescriptor[] arr = PropertyUtils.getPropertyDescriptors(clazz);
        for (PropertyDescriptor desc : arr) {
            if (!LangUtils.isNoCopy(desc) || rc.contains(desc.getName())) continue;
            rc.add(desc.getName());
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.collectForbiddenCopies(rc, clazz2);
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            this.collectForbiddenCopies(rc, clazz2);
        }
    }

    public boolean isTransient(Object bean, String propertyName) {
        return this.getTransientProperties(bean).contains(propertyName);
    }

    public List<String> getTransientProperties(Object bean) {
        Class<?> clazz = bean instanceof Class ? (Class<?>)bean : bean.getClass();
        List<String> rc = this.transientProperties.get(clazz);
        if (rc == null) {
            rc = new ArrayList<String>();
            this.collectTransientProperties(rc, clazz);
            this.transientProperties.put(clazz, Collections.unmodifiableList(rc));
        }
        return rc;
    }

    public List<String> getNonTransientProperties(Object bean) {
        Class<?> clazz = bean instanceof Class ? (Class<?>)bean : bean.getClass();
        List<String> rc = this.nonTransientProperties.get(clazz);
        if (rc == null) {
            rc = new ArrayList<String>();
            List<String> transientProperties = this.getTransientProperties(clazz);
            for (PropertyDescriptor desc : PropertyUtils.getPropertyDescriptors(clazz)) {
                if (transientProperties.contains(desc.getName())) continue;
                rc.add(desc.getName());
            }
            this.nonTransientProperties.put(clazz, Collections.unmodifiableList(rc));
        }
        return rc;
    }

    protected void collectTransientProperties(List<String> rc, Class<?> clazz) {
        for (PropertyDescriptor desc : PropertyUtils.getPropertyDescriptors(clazz)) {
            if (!LangUtils.isTransient(desc) || rc.contains(desc.getName())) continue;
            rc.add(desc.getName());
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.collectTransientProperties(rc, clazz2);
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            this.collectTransientProperties(rc, clazz2);
        }
    }
}

