/*
 * This file is part of RS Library (Base Library).
 *
 *  RS Library is free software: you can redistribute it 
 *  and/or modify it under the terms of version 3 of the GNU 
 *  Lesser General Public  License as published by the Free Software 
 *  Foundation.
 *  
 *  RS Library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public 
 *  License along with RS Library.  If not, see 
 *  <http://www.gnu.org/licenses/lgpl-3.0.html>.
 */
package rs.baselib.type;

import java.io.Serializable;

import javax.persistence.Transient;

/**
 * An object having an ID.
 * @author ralph
 * @since 1.2.9
 *
 * @param <T> the type of the ID
 */
public interface IIdObject<T extends Serializable> {

	/** 
	 * Property name of ID.
	 * @since 1.2.9 
	 */
	public static final String ID = "id";
	
	/** 
	 * Returns the ID.
	 * @return the ID of the object 
	 */
	@Transient
	public T getId();
	
}
