/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import rs.baselib.util.RsDate;

public class ReleaseInformation {
    public static final String KEY_GROUP_ID = "groupId";
    public static final String KEY_ARTIFACT_ID = "artifactId";
    public static final String KEY_VERSION = "version";
    public static final String KEY_NAME = "name";
    public static final String KEY_SVN_REPOSITORY = "repository";
    public static final String KEY_SVN_PATH = "path";
    public static final String KEY_SVN_REVISION = "revision";
    public static final String KEY_SVN_MIXED_REVISIONS = "mixedRevisions";
    public static final String KEY_SVN_COMMITTED_REVISION = "committedRevision";
    public static final String KEY_SVN_COMMITTED_DATE = "committedDate";
    public static final String KEY_SVN_STATUS = "status";
    public static final String KEY_SVN_SPECIAL_STATUS = "specialStatus";
    public static final String KEY_BUILD_DATE = "buildDate";
    private String groupId;
    private String artifactId;
    private String version;
    private String name;
    private String svnRepository;
    private String svnPath;
    private long svnRevision;
    private boolean svnMixedRevisions;
    private long svnCommittedRevision;
    private RsDate svnCommittedDate;
    private String svnStatus;
    private String svnSpecialStatus;
    private RsDate buildDate;

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSvnRepository() {
        return this.svnRepository;
    }

    public void setSvnRepository(String svnRepository) {
        this.svnRepository = svnRepository;
    }

    public String getSvnPath() {
        return this.svnPath;
    }

    public void setSvnPath(String svnPath) {
        this.svnPath = svnPath;
    }

    public long getSvnRevision() {
        return this.svnRevision;
    }

    public void setSvnRevision(long svnRevision) {
        this.svnRevision = svnRevision;
    }

    public boolean isSvnMixedRevisions() {
        return this.svnMixedRevisions;
    }

    public void setSvnMixedRevisions(boolean svnMixedRevisions) {
        this.svnMixedRevisions = svnMixedRevisions;
    }

    public long getSvnCommittedRevision() {
        return this.svnCommittedRevision;
    }

    public void setSvnCommittedRevision(long svnCommittedRevision) {
        this.svnCommittedRevision = svnCommittedRevision;
    }

    public RsDate getSvnCommittedDate() {
        return this.svnCommittedDate;
    }

    public void setSvnCommittedDate(RsDate svnCommittedDate) {
        this.svnCommittedDate = svnCommittedDate;
    }

    public void setSvnCommittedDate(Date svnCommittedDate) {
        this.setSvnCommittedDate(svnCommittedDate != null ? new RsDate(svnCommittedDate) : null);
    }

    public String getSvnStatus() {
        return this.svnStatus;
    }

    public void setSvnStatus(String svnStatus) {
        this.svnStatus = svnStatus;
    }

    public String getSvnSpecialStatus() {
        return this.svnSpecialStatus;
    }

    public void setSvnSpecialStatus(String svnSpecialStatus) {
        this.svnSpecialStatus = svnSpecialStatus;
    }

    public RsDate getBuildDate() {
        return this.buildDate;
    }

    public void setBuildDate(RsDate buildDate) {
        this.buildDate = buildDate;
    }

    public void setBuildDate(Date buildDate) {
        this.setBuildDate(buildDate != null ? new RsDate(buildDate) : null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReleaseInformation)) {
            return false;
        }
        ReleaseInformation other = (ReleaseInformation)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public void set(String key, String value) throws ParseException {
        if (value != null && value.startsWith("${")) {
            value = null;
        }
        if (value == null) {
            return;
        }
        SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        if (ReleaseInformation.isKey(key, KEY_GROUP_ID)) {
            this.setGroupId(value);
        } else if (ReleaseInformation.isKey(key, KEY_ARTIFACT_ID)) {
            this.setArtifactId(value);
        } else if (ReleaseInformation.isKey(key, KEY_VERSION)) {
            this.setVersion(value);
        } else if (ReleaseInformation.isKey(key, KEY_NAME)) {
            this.setName(value);
        } else if (ReleaseInformation.isKey(key, KEY_SVN_REPOSITORY)) {
            this.setSvnRepository(value);
        } else if (ReleaseInformation.isKey(key, KEY_SVN_PATH)) {
            this.setSvnPath(value);
        } else if (ReleaseInformation.isKey(key, KEY_SVN_REVISION)) {
            this.setSvnRevision(Long.parseLong(value));
        } else if (ReleaseInformation.isKey(key, KEY_SVN_MIXED_REVISIONS)) {
            this.setSvnMixedRevisions(value.equalsIgnoreCase("true"));
        } else if (ReleaseInformation.isKey(key, KEY_SVN_COMMITTED_REVISION)) {
            this.setSvnCommittedRevision(Long.parseLong(value));
        } else if (ReleaseInformation.isKey(key, KEY_SVN_COMMITTED_DATE)) {
            this.setSvnCommittedDate(DATE_FORMATTER.parse(value));
        } else if (ReleaseInformation.isKey(key, KEY_SVN_STATUS)) {
            this.setSvnStatus(value);
        } else if (ReleaseInformation.isKey(key, KEY_SVN_SPECIAL_STATUS)) {
            this.setSvnSpecialStatus(value);
        } else if (ReleaseInformation.isKey(key, KEY_BUILD_DATE)) {
            this.setBuildDate(DATE_FORMATTER.parse(value));
        }
    }

    private static boolean isKey(String key, String suffix) {
        return key.endsWith("." + suffix) || key.equals(suffix);
    }

    public boolean isValid() {
        return this.getGroupId() != null && this.getArtifactId() != null && this.getVersion() != null;
    }

    public boolean isSnapshot() {
        String version = this.getVersion();
        return version == null || version.endsWith("-SNAPSHOT");
    }

    public String toString() {
        return this.getName() + "[" + this.getGroupId() + ":" + this.getArtifactId() + "] - V" + this.getVersion();
    }
}

