/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.util;

import org.apache.commons.beanutils.PropertyUtils;
import rs.baselib.util.IValueProvider;

public class BeanValueProvider
implements IValueProvider {
    private String beanProperty;
    private Object nullValue = null;

    public BeanValueProvider(String beanProperty) {
        this.setBeanProperty(beanProperty);
    }

    @Override
    public Object getValue(Object o) {
        try {
            if (o == null) {
                return this.getNullValue();
            }
            Object value = o;
            if (this.getBeanProperty() != null) {
                value = PropertyUtils.getProperty((Object)o, (String)this.getBeanProperty());
            }
            if (value == null) {
                value = this.getNullValue();
            }
            return value;
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot retrieve value:", t);
        }
    }

    public String getBeanProperty() {
        return this.beanProperty;
    }

    public void setBeanProperty(String beanProperty) {
        this.beanProperty = beanProperty;
    }

    public Object getNullValue() {
        return this.nullValue;
    }

    public void setNullValue(Object nullValue) {
        this.nullValue = nullValue;
    }

    public static BeanValueProvider[] getValueProviders(String ... beanProperties) {
        BeanValueProvider[] rc = new BeanValueProvider[beanProperties.length];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = new BeanValueProvider(beanProperties[i]);
        }
        return rc;
    }
}

