/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AdvancedThreadLocal<T> {
    private volatile Map<Thread, T> map = new HashMap<Thread, T>();
    private ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private Lock readLock = this.rwLock.readLock();
    private Lock writeLock = this.rwLock.writeLock();

    protected T initialValue() {
        return null;
    }

    public T get() {
        T rc;
        block7: {
            rc = null;
            try {
                this.readLock.lock();
                if (this.map.containsKey(Thread.currentThread())) {
                    rc = this.map.get(Thread.currentThread());
                    break block7;
                }
                rc = this.initialValue();
                try {
                    this.readLock.unlock();
                    this.set(rc);
                }
                finally {
                    this.readLock.lock();
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        return rc;
    }

    public T set(T value) {
        try {
            this.writeLock.lock();
            T t = this.map.put(Thread.currentThread(), value);
            return t;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public T remove() {
        try {
            this.writeLock.lock();
            T t = this.map.remove(Thread.currentThread());
            return t;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Collection<Map.Entry<Thread, T>> getEntries() {
        try {
            this.readLock.lock();
            HashSet<Map.Entry<Thread, T>> hashSet = new HashSet<Map.Entry<Thread, T>>(this.map.entrySet());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyThreads() {
        try {
            this.writeLock.lock();
            Set<Thread> keys = this.map.keySet();
            HashSet<Thread> remove = new HashSet<Thread>();
            for (Thread t : keys) {
                if (t.isAlive() && !t.isInterrupted()) continue;
                remove.add(t);
            }
            for (Thread t : remove) {
                this.map.remove(t);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clear() {
        try {
            this.writeLock.lock();
            this.map.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

