/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.type;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import rs.baselib.lang.HashCodeUtil;

public class MonetaryValue
implements Serializable,
Comparable<MonetaryValue> {
    private static final long serialVersionUID = 1L;
    public static final RoundingMode ROUNDING_MODE = RoundingMode.HALF_EVEN;
    public static final MathContext MATH_CONTEXT = MathContext.DECIMAL128;
    public static final int DEFAULT_SCALE = 2;
    public static final MonetaryValue ZERO = new MonetaryValue(0);
    private BigDecimal amount;
    private RoundingMode roundingMode;
    private int scale;
    private MathContext mathContext;

    public MonetaryValue(BigDecimal value) {
        this(value, ROUNDING_MODE);
    }

    public MonetaryValue(MonetaryValue value) {
        this(value.getAmount(), value.getRoundingMode());
    }

    public MonetaryValue(BigDecimal value, RoundingMode roundingMode) {
        this(value, roundingMode, MATH_CONTEXT, 2);
    }

    public MonetaryValue(BigDecimal value, RoundingMode roundingMode, MathContext mathContext, int scale) {
        this.amount = value.setScale(scale, roundingMode);
        this.roundingMode = roundingMode;
        this.scale = scale;
        this.mathContext = mathContext;
    }

    public MonetaryValue(CharSequence value) {
        this(new BigDecimal(value.toString(), MATH_CONTEXT));
    }

    public MonetaryValue(double value) {
        this(new BigDecimal(value, MATH_CONTEXT));
    }

    public MonetaryValue(BigInteger value) {
        this(new BigDecimal(value, MATH_CONTEXT));
    }

    public MonetaryValue(int value) {
        this(new BigDecimal(value, MATH_CONTEXT));
    }

    public MonetaryValue(long value) {
        this(new BigDecimal(value, MATH_CONTEXT));
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public MathContext getMathContext() {
        return this.mathContext;
    }

    public void setMathContext(MathContext mathContext) {
        this.mathContext = mathContext;
    }

    public boolean isPositive() {
        return this.amount.signum() > 0;
    }

    public boolean isNegative() {
        return this.amount.signum() < 0;
    }

    public boolean isZero() {
        return this.amount.signum() == 0;
    }

    public MonetaryValue add(MonetaryValue value) {
        return new MonetaryValue(this.amount.add(value.getAmount(), this.getMathContext()), this.getRoundingMode(), this.getMathContext(), this.getScale());
    }

    public MonetaryValue add(BigDecimal value) {
        return this.add(new MonetaryValue(value));
    }

    public MonetaryValue add(int value) {
        return this.add(new MonetaryValue(value));
    }

    public MonetaryValue add(long value) {
        return this.add(new MonetaryValue(value));
    }

    public MonetaryValue add(double value) {
        return this.add(new MonetaryValue(value));
    }

    public MonetaryValue add(BigInteger value) {
        return this.add(new MonetaryValue(value));
    }

    public MonetaryValue add(CharSequence value) {
        return this.add(new MonetaryValue(value));
    }

    public MonetaryValue subtract(MonetaryValue value) {
        return new MonetaryValue(this.amount.subtract(value.getAmount(), this.getMathContext()), this.getRoundingMode(), this.getMathContext(), this.getScale());
    }

    public MonetaryValue subtract(BigDecimal value) {
        return this.subtract(new MonetaryValue(value));
    }

    public MonetaryValue subtract(int value) {
        return this.subtract(new MonetaryValue(value));
    }

    public MonetaryValue subtract(long value) {
        return this.subtract(new MonetaryValue(value));
    }

    public MonetaryValue subtract(double value) {
        return this.subtract(new MonetaryValue(value));
    }

    public MonetaryValue subtract(BigInteger value) {
        return this.subtract(new MonetaryValue(value));
    }

    public MonetaryValue subtract(CharSequence value) {
        return this.subtract(new MonetaryValue(value));
    }

    public MonetaryValue multiply(BigDecimal value) {
        return new MonetaryValue(this.amount.multiply(value, this.getMathContext()), this.getRoundingMode(), this.getMathContext(), this.getScale());
    }

    public MonetaryValue multiply(int value) {
        return this.multiply(new BigDecimal(value));
    }

    public MonetaryValue multiply(long value) {
        return this.multiply(new BigDecimal(value));
    }

    public MonetaryValue multiply(double value) {
        return this.multiply(new BigDecimal(value));
    }

    public MonetaryValue multiply(BigInteger value) {
        return this.multiply(new BigDecimal(value));
    }

    public MonetaryValue multiply(CharSequence value) {
        return this.multiply(new BigDecimal(value.toString().toCharArray()));
    }

    public MonetaryValue divide(BigDecimal value) {
        return new MonetaryValue(this.amount.divide(value, this.getMathContext()), this.getRoundingMode(), this.getMathContext(), this.getScale());
    }

    public MonetaryValue divide(int value) {
        return this.divide(new BigDecimal(value));
    }

    public MonetaryValue divide(long value) {
        return this.divide(new BigDecimal(value));
    }

    public MonetaryValue divide(double value) {
        return this.divide(new BigDecimal(value));
    }

    public MonetaryValue divide(BigInteger value) {
        return this.divide(new BigDecimal(value));
    }

    public MonetaryValue divide(CharSequence value) {
        return this.divide(new BigDecimal(value.toString().toCharArray()));
    }

    public BigDecimal divide(MonetaryValue value) {
        return this.amount.divide(value.getAmount(), this.getMathContext());
    }

    public MonetaryValue negate() {
        return new MonetaryValue(this.amount.negate(this.getMathContext()), this.getRoundingMode(), this.getMathContext(), this.getScale());
    }

    public double getDouble() {
        return this.amount.doubleValue();
    }

    public float getFloat() {
        return this.amount.floatValue();
    }

    public int getInt() {
        return this.amount.intValue();
    }

    public BigInteger getBigInteger() {
        return this.amount.toBigInteger();
    }

    public long getLong() {
        return this.amount.longValue();
    }

    @Override
    public int compareTo(MonetaryValue o) {
        return this.amount.compareTo(o.getAmount());
    }

    public int hashCode() {
        int rc = 23;
        rc = HashCodeUtil.hash(rc, (Object)this.roundingMode);
        rc = HashCodeUtil.hash(rc, this.amount);
        return rc;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MonetaryValue)) {
            return false;
        }
        MonetaryValue that = (MonetaryValue)other;
        boolean result = this.amount.equals(that.amount);
        result = result && this.roundingMode == that.roundingMode;
        return result;
    }

    public String toString() {
        return this.amount.toPlainString();
    }
}

