/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.test;

import java.util.TimeZone;
import rs.baselib.test.Builder;
import rs.baselib.util.RsYear;

public class RsYearBuilder
implements Builder<RsYear> {
    private Long time = null;
    private Builder<Long> timeBuilder = null;
    private Integer year = null;
    private Builder<Integer> yearBuilder = null;
    private TimeZone timezone = null;

    public RsYearBuilder withTime(long timeInMilliseconds) {
        this.time = timeInMilliseconds;
        return this;
    }

    public RsYearBuilder withTime(Builder<Long> timeBuilder) {
        this.timeBuilder = timeBuilder;
        return this;
    }

    public RsYearBuilder withYear(int year) {
        this.year = year;
        return this;
    }

    public RsYearBuilder withYear(Builder<Integer> yearBuilder) {
        this.yearBuilder = yearBuilder;
        return this;
    }

    public RsYearBuilder withTimezone(TimeZone timezone) {
        this.timezone = timezone;
        return this;
    }

    @Override
    public RsYear build() {
        RsYear rc = null;
        if (this.year != null) {
            rc = this.timezone != null ? new RsYear(this.timezone, this.year) : new RsYear(this.year);
        } else if (this.yearBuilder != null) {
            rc = this.timezone != null ? new RsYear(this.timezone, this.yearBuilder.build()) : new RsYear(this.yearBuilder.build());
        } else {
            long t = System.currentTimeMillis();
            if (this.time != null) {
                t = this.time;
            } else if (this.timeBuilder != null) {
                t = this.timeBuilder.build();
            }
            rc = this.timezone != null ? new RsYear(this.timezone, t) : new RsYear(t);
        }
        return rc;
    }
}

