/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.test;

import java.util.TimeZone;
import rs.baselib.test.Builder;
import rs.baselib.util.RsMonth;

public class RsMonthBuilder
implements Builder<RsMonth> {
    private Long time = null;
    private Builder<Long> timeBuilder = null;
    private TimeZone timezone = null;
    private Integer monthOffset = null;
    private int count = 0;

    public RsMonthBuilder withTime(long timeInMilliseconds) {
        this.time = timeInMilliseconds;
        return this;
    }

    public RsMonthBuilder withTime(Builder<Long> timeBuilder) {
        this.timeBuilder = timeBuilder;
        return this;
    }

    public RsMonthBuilder withTimezone(TimeZone timezone) {
        this.timezone = timezone;
        return this;
    }

    public RsMonthBuilder withMonthOffset(int months) {
        this.monthOffset = months;
        return this;
    }

    @Override
    public RsMonth build() {
        RsMonth rc = null;
        if (this.timeBuilder != null) {
            rc = this.timezone != null ? new RsMonth(this.timezone, this.timeBuilder.build()) : new RsMonth(this.timeBuilder.build());
        } else {
            long t = System.currentTimeMillis();
            if (this.time != null) {
                t = this.time;
            }
            rc = this.timezone != null ? new RsMonth(this.timezone, t) : new RsMonth(t);
            if (this.monthOffset != null) {
                for (int i = 0; i < this.count; ++i) {
                    int j;
                    if (this.monthOffset < 0) {
                        for (j = this.monthOffset.intValue(); j < 0; ++j) {
                            rc = rc.getPrevious();
                        }
                        continue;
                    }
                    for (j = 0; j < this.monthOffset; ++j) {
                        rc = rc.getNext();
                    }
                }
                ++this.count;
            }
            if (this.time == null) {
                this.time = rc.getBegin().getTimeInMillis();
            }
        }
        return rc;
    }
}

