/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.test;

import java.util.TimeZone;
import rs.baselib.test.Builder;
import rs.baselib.util.RsDate;

public class RsDateBuilder
implements Builder<RsDate> {
    private Long time = null;
    private Builder<Long> timeBuilder = null;
    private TimeZone timezone = null;

    public RsDateBuilder withTime(long timeInMilliseconds) {
        this.time = timeInMilliseconds;
        return this;
    }

    public RsDateBuilder withTime(Builder<Long> timeBuilder) {
        this.timeBuilder = timeBuilder;
        return this;
    }

    public RsDateBuilder withTimezone(TimeZone timezone) {
        this.timezone = timezone;
        return this;
    }

    @Override
    public RsDate build() {
        long time = System.currentTimeMillis();
        if (this.time != null) {
            time = this.time;
        } else if (this.timeBuilder != null) {
            time = this.timeBuilder.build();
        }
        RsDate rc = new RsDate(time);
        if (this.timezone != null) {
            rc.setTimeZone(this.timezone);
        }
        return rc;
    }
}

