/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.test;

import org.apache.commons.lang.math.RandomUtils;
import rs.baselib.test.Builder;

public class LongBuilder
implements Builder<Long> {
    private long count = 0L;
    private long offset = 1L;
    private long end;
    private boolean random = false;

    public LongBuilder withStart(long start) {
        this.count = start;
        return this;
    }

    public LongBuilder withOffset(long offset) {
        this.offset = offset;
        return this;
    }

    public LongBuilder withEnd(long end) {
        this.end = end;
        return this;
    }

    public LongBuilder withRandom() {
        this.random = true;
        return this;
    }

    @Override
    public Long build() {
        Long rc = 0L;
        if (!this.random) {
            rc = this.count;
            this.count += this.offset;
        } else {
            long l = RandomUtils.nextLong() + this.count;
            while (l > this.end) {
                l = RandomUtils.nextLong() + this.count;
            }
            rc = l;
        }
        return rc;
    }
}

