/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.test;

import org.apache.commons.lang.math.RandomUtils;
import rs.baselib.test.Builder;

public class IntBuilder
implements Builder<Integer> {
    private int count = 0;
    private int offset = 1;
    private int end;
    private boolean random = false;

    public IntBuilder withStart(int start) {
        this.count = start;
        return this;
    }

    public IntBuilder withOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public IntBuilder withEnd(int end) {
        this.end = end;
        return this;
    }

    public IntBuilder withRandom() {
        this.random = true;
        return this;
    }

    @Override
    public Integer build() {
        Integer rc = 0;
        if (!this.random) {
            rc = this.count;
            this.count += this.offset;
        } else {
            rc = RandomUtils.nextInt((int)(this.end - this.count)) + this.count;
        }
        return rc;
    }
}

