/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.security;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.io.FileUtils;
import rs.baselib.configuration.IConfigurable;
import rs.baselib.security.AbstractAuthorizationCallback;

public class TextFileAuthorizationCallback
extends AbstractAuthorizationCallback
implements IConfigurable {
    @Override
    public void configure(Configuration config) throws ConfigurationException {
        String path = config.getString("File");
        this.configure(path);
    }

    public void configure(String file) throws ConfigurationException {
        this.configure(new File(file));
    }

    public void configure(File file) throws ConfigurationException {
        try {
            String s = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
            int pos = s.indexOf(58);
            if (pos <= 0) {
                throw new ConfigurationException("Invalid text file format: " + file.getAbsolutePath());
            }
            this.setName(s.substring(0, pos));
            this.setPassword(s.substring(pos + 1));
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot read file", (Throwable)e);
        }
    }
}

