/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.security;

import java.io.Console;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import rs.baselib.configuration.IConfigurable;
import rs.baselib.security.AbstractAuthorizationCallback;

public class CommandLineAuthorizationCallback
extends AbstractAuthorizationCallback
implements IConfigurable {
    public static final String DEFAULT_LOGIN_PROMPT = "Login: ";
    public static final String DEFAULT_PASSWORD_PROMPT = "Password: ";
    private String loginPrompt;
    private String passwordPrompt;

    @Override
    public void configure(Configuration config) throws ConfigurationException {
        this.setName(config.getString("login"));
        this.setLoginPrompt(config.getString("login-prompt"));
        this.setPasswordPrompt(config.getString("password-prompt"));
    }

    public String getLoginPrompt() {
        return this.loginPrompt;
    }

    public void setLoginPrompt(String loginPrompt) {
        if (loginPrompt == null) {
            loginPrompt = DEFAULT_LOGIN_PROMPT;
        }
        this.loginPrompt = loginPrompt;
    }

    public String getPasswordPrompt() {
        return this.passwordPrompt;
    }

    public void setPasswordPrompt(String passwordPrompt) {
        if (passwordPrompt == null) {
            passwordPrompt = DEFAULT_PASSWORD_PROMPT;
        }
        this.passwordPrompt = passwordPrompt;
    }

    @Override
    public String getName() {
        String s = super.getName();
        if (s != null) {
            return s;
        }
        System.out.print(this.getLoginPrompt());
        System.out.flush();
        Console con = System.console();
        if (con != null) {
            s = con.readLine();
            super.setName(s);
            return s;
        }
        throw new IllegalStateException("No console available");
    }

    @Override
    public String getPassword() {
        String s = super.getPassword();
        if (s != null) {
            return s;
        }
        System.out.print(this.getPasswordPrompt());
        System.out.flush();
        Console con = System.console();
        if (con != null) {
            char[] pwd = con.readPassword();
            s = pwd != null ? new String(pwd) : "";
            super.setPassword(s);
            return s;
        }
        throw new IllegalStateException("No console available");
    }
}

