/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.php;

import java.nio.charset.Charset;
import java.util.HashMap;
import rs.baselib.php.PhpUnserializeException;

public class PhpUnserializer {
    public static Object unserialize(String data) {
        return PhpUnserializer.unserialize(data, (Charset)null);
    }

    public static Object unserialize(String data, Charset charset) {
        return PhpUnserializer.unserialize(data, new ParseInfo(charset));
    }

    private static Object unserialize(String data, ParseInfo parseInfo) {
        Object result;
        char type = data.charAt(parseInfo.pos);
        switch (type) {
            case 's': {
                result = PhpUnserializer.unserializeString(data, parseInfo);
                break;
            }
            case 'i': {
                result = PhpUnserializer.unserializeInteger(data, parseInfo);
                break;
            }
            case 'd': {
                result = PhpUnserializer.unserializeDouble(data, parseInfo);
                break;
            }
            case 'b': {
                result = PhpUnserializer.unserializeBoolean(data, parseInfo);
                break;
            }
            case 'N': {
                result = PhpUnserializer.unserializeNull(data, parseInfo);
                break;
            }
            case 'a': {
                result = PhpUnserializer.unserializeArray(data, parseInfo);
                break;
            }
            default: {
                throw new PhpUnserializeException("Unable to unserialize unknown type " + type);
            }
        }
        return result;
    }

    private static String unserializeString(String data, ParseInfo parseInfo) {
        int pos = data.indexOf(58, parseInfo.pos + 2);
        int length = Integer.parseInt(data.substring(parseInfo.pos + 2, pos));
        parseInfo.pos = pos + length + 3;
        byte[] unencoded = data.substring(pos + 2, pos + 2 + length).getBytes();
        return PhpUnserializer.encode(unencoded, parseInfo.charset);
    }

    private static Number unserializeInteger(String data, ParseInfo parseInfo) {
        int pos = PhpUnserializer.getNumberEndPosition(data, parseInfo.pos + 2);
        String s = data.substring(parseInfo.pos + 2, pos);
        parseInfo.pos = pos;
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException numberFormatException2) {
                return Double.parseDouble(s);
            }
        }
    }

    private static Number unserializeDouble(String data, ParseInfo parseInfo) {
        int pos = PhpUnserializer.getNumberEndPosition(data, parseInfo.pos + 2);
        String s = data.substring(parseInfo.pos + 2, pos);
        parseInfo.pos = pos;
        if (s.indexOf(46) < 0) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Long.parseLong(s);
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
        }
        return Double.parseDouble(s);
    }

    private static boolean unserializeBoolean(String data, ParseInfo parseInfo) {
        Boolean result = data.charAt(parseInfo.pos + 2) == '1';
        parseInfo.pos += 3;
        return result;
    }

    private static Object unserializeNull(String data, ParseInfo parseInfo) {
        ++parseInfo.pos;
        return null;
    }

    private static Object unserializeArray(String data, ParseInfo parseInfo) {
        int i;
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        boolean decimalSequence = true;
        int pos = data.indexOf(58, parseInfo.pos + 2);
        int max = Integer.parseInt(data.substring(parseInfo.pos + 2, pos));
        parseInfo.pos = pos + 2;
        for (i = 0; i < max; ++i) {
            Object key = PhpUnserializer.unserialize(data, parseInfo);
            if (data.charAt(parseInfo.pos) == ';') {
                ++parseInfo.pos;
            }
            Object value = PhpUnserializer.unserialize(data, parseInfo);
            if (data.charAt(parseInfo.pos) == ';') {
                ++parseInfo.pos;
            }
            result.put(key, value);
            if (!decimalSequence) continue;
            if (!(key instanceof Integer)) {
                decimalSequence = false;
                continue;
            }
            int keyNum = Integer.parseInt(key.toString());
            if (keyNum == i) continue;
            decimalSequence = false;
        }
        ++parseInfo.pos;
        if (decimalSequence) {
            Object[] rc = new Object[max];
            for (i = 0; i < max; ++i) {
                rc[i] = result.get(i);
            }
            return rc;
        }
        return result;
    }

    protected static int getNumberEndPosition(String data, int pos) {
        for (int i = pos; i < data.length(); ++i) {
            char c = data.charAt(i);
            if (Character.isDigit(c) || c == '.') continue;
            return i;
        }
        return data.length();
    }

    public static String encode(byte[] decoded, Charset charset) {
        return new String(decoded, charset);
    }

    private static class ParseInfo {
        int pos = 0;
        Charset charset;

        public ParseInfo(Charset charset) {
            if (charset == null) {
                charset = Charset.forName("UTF-8");
            }
            this.charset = charset;
        }
    }
}

