/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.licensing.internal;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import rs.baselib.crypto.EncryptionUtils;
import rs.baselib.io.ConverterUtils;
import rs.baselib.licensing.ILicense;
import rs.baselib.licensing.ILicenseContext;
import rs.baselib.licensing.ILicenseVerifier;
import rs.baselib.licensing.LicenseException;

public class RsaLicenseVerifier
implements ILicenseVerifier {
    private Base64 decoder = new Base64(64);

    @Override
    public ILicense verify(String licenseKey, ILicenseContext context) {
        try {
            byte[] bytes = this.decrypt(context, this.decoder.decode(licenseKey));
            ILicense license = (ILicense)ConverterUtils.toObject(bytes);
            license.verify(context);
            return license;
        }
        catch (LicenseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new LicenseException("Invalid license: " + licenseKey, t);
        }
    }

    protected byte[] decrypt(ILicenseContext context, byte[] bytes) throws GeneralSecurityException, IOException {
        int blockSize;
        Cipher cipher = context.get(Cipher.class);
        if (cipher == null) {
            cipher = Cipher.getInstance("RSA");
            cipher.init(2, context.get(Key.class));
            context.set(Cipher.class, cipher);
        }
        if ((blockSize = cipher.getBlockSize()) == 0) {
            blockSize = 256;
        }
        return EncryptionUtils.crypt(bytes, cipher, blockSize);
    }
}

