/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.licensing.internal;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import rs.baselib.crypto.EncryptionUtils;
import rs.baselib.io.ConverterUtils;
import rs.baselib.licensing.ILicense;
import rs.baselib.licensing.ILicenseContext;
import rs.baselib.licensing.ILicenseCreator;
import rs.baselib.licensing.LicenseException;

public class RsaLicenseCreator
implements ILicenseCreator {
    private Base64 encoder = new Base64(64);

    @Override
    public String createLicenseKey(ILicenseContext context, ILicense license) {
        try {
            byte[] licenseBytes = ConverterUtils.toBytes(license);
            byte[] bytes = this.encrypt(context, licenseBytes);
            return this.encoder.encodeToString(bytes);
        }
        catch (LicenseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new LicenseException("Cannot create license key", t);
        }
    }

    protected byte[] encrypt(ILicenseContext context, byte[] bytes) throws GeneralSecurityException, IOException {
        int blockSize;
        Cipher cipher = context.get(Cipher.class);
        if (cipher == null) {
            cipher = Cipher.getInstance("RSA");
            cipher.init(1, context.get(Key.class));
            context.set(Cipher.class, cipher);
        }
        if ((blockSize = cipher.getBlockSize()) == 0) {
            blockSize = 245;
        }
        return EncryptionUtils.crypt(bytes, cipher, blockSize);
    }
}

