/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.licensing.internal;

import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import org.apache.commons.codec.binary.Base32;
import rs.baselib.crypto.DataSigner;
import rs.baselib.crypto.DecryptionException;
import rs.baselib.crypto.SigningException;
import rs.baselib.io.ConverterUtils;
import rs.baselib.licensing.ILicense;
import rs.baselib.licensing.ILicenseContext;
import rs.baselib.licensing.ILicenseCreator;
import rs.baselib.licensing.LicenseException;
import rs.baselib.licensing.SimpleLicense;

public class OctetLicenseCreator
implements ILicenseCreator {
    private Base32 encoder = new Base32(true);

    @Override
    public String createLicenseKey(ILicenseContext context, ILicense license) {
        try {
            SimpleLicense lic = (SimpleLicense)license;
            byte[] licenseBytes = SimpleLicense.serialize(lic);
            byte[] signature = this.sign(context, licenseBytes);
            byte[] bytes = this.combine((int)(lic.getExpiration() / 1000L), signature);
            return OctetLicenseCreator.group(this.encoder.encodeToString(bytes));
        }
        catch (LicenseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new LicenseException("Cannot create license key", t);
        }
    }

    protected byte[] sign(ILicenseContext context, byte[] bytes) throws SigningException, NoSuchAlgorithmException, DecryptionException {
        DataSigner signer = context.get(DataSigner.class);
        if (signer == null) {
            signer = new DataSigner(context.get(PrivateKey.class));
            context.set(DataSigner.class, signer);
        }
        return signer.getByteSignature(bytes);
    }

    protected byte[] combine(int prefix, byte[] signature) {
        int len = signature.length + 4;
        byte[] rc = new byte[len];
        System.arraycopy(ConverterUtils.toBytes(prefix), 0, rc, 0, 4);
        System.arraycopy(signature, 0, rc, 4, signature.length);
        for (int i = 0; i < 4; ++i) {
            rc[i] = (byte)(rc[i] ^ rc[4 + i]);
        }
        return rc;
    }

    public static String group(String s) {
        StringBuilder b = new StringBuilder(s.length() + 10);
        int count = 0;
        for (char c : s.toCharArray()) {
            if (count >= 8) {
                b.append('-');
                count = 0;
            }
            b.append(c);
            ++count;
        }
        while (b.charAt(b.length() - 1) == '=') {
            b.deleteCharAt(b.length() - 1);
        }
        return b.toString();
    }
}

